/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis.binding;

import com.mybatisflex.annotation.UseDataSource;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.datasource.DataSourceKey;
import com.mybatisflex.core.datasource.FlexDataSource;
import com.mybatisflex.core.dialect.DbType;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.mybatis.FlexConfiguration;
import com.mybatisflex.core.mybatis.binding.MybatisMapperProxy;
import com.mybatisflex.core.row.RowMapper;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.SqlSession;

public class FlexMapperProxy<T>
extends MybatisMapperProxy<T> {
    private final FlexDataSource dataSource;

    public FlexMapperProxy(SqlSession sqlSession, Class<T> mapperInterface, Map<Method, MybatisMapperProxy.MapperMethodInvoker> methodCache, FlexConfiguration configuration) {
        super(sqlSession, mapperInterface, methodCache);
        this.dataSource = (FlexDataSource)configuration.getEnvironment().getDataSource();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String userDsKey;
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        boolean needClearDsKey = false;
        boolean needClearDbType = false;
        String finalDsKey = userDsKey = DataSourceKey.get();
        try {
            DbType hintDbType;
            if (StringUtil.isBlank(finalDsKey)) {
                finalDsKey = FlexMapperProxy.getMethodDsKey(method, proxy);
            }
            if (StringUtil.isNotBlank(finalDsKey = DataSourceKey.getShardingDsKey(finalDsKey, proxy, method, args)) && !finalDsKey.equals(userDsKey)) {
                needClearDsKey = true;
                DataSourceKey.use(finalDsKey);
            }
            if ((hintDbType = DialectFactory.getHintDbType()) == null) {
                if (finalDsKey != null && this.dataSource != null) {
                    hintDbType = this.dataSource.getDbType(finalDsKey);
                }
                if (hintDbType == null) {
                    hintDbType = FlexGlobalConfig.getDefaultConfig().getDbType();
                }
                needClearDbType = true;
                DialectFactory.setHintDbType(hintDbType);
            }
            Object object = this.cachedInvoker(method).invoke(proxy, method, args, this.sqlSession);
            return object;
        }
        catch (Throwable e) {
            throw ExceptionUtil.unwrapThrowable((Throwable)e);
        }
        finally {
            if (needClearDbType) {
                DialectFactory.clearHintDbType();
            }
            if (needClearDsKey) {
                if (userDsKey != null) {
                    DataSourceKey.use(userDsKey);
                } else {
                    DataSourceKey.clear();
                }
            }
        }
    }

    private static String getMethodDsKey(Method method, Object proxy) {
        String tableDsKey;
        TableInfo tableInfo;
        Class<?>[] interfaces;
        UseDataSource methodAnno = method.getAnnotation(UseDataSource.class);
        if (methodAnno != null && StringUtil.isNotBlank(methodAnno.value())) {
            return methodAnno.value();
        }
        for (Class<?> anInterface : interfaces = proxy.getClass().getInterfaces()) {
            UseDataSource classAnno = anInterface.getAnnotation(UseDataSource.class);
            if (classAnno == null || !StringUtil.isNotBlank(classAnno.value())) continue;
            return classAnno.value();
        }
        if (interfaces[0] != RowMapper.class && (tableInfo = TableInfoFactory.ofMapperClass(interfaces[0])) != null && StringUtil.isNotBlank(tableDsKey = tableInfo.getDataSource())) {
            return tableDsKey;
        }
        return null;
    }
}

