/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.properties;

import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.properties.HystrixDynamicProperties;
import com.netflix.hystrix.strategy.properties.HystrixDynamicProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HystrixPropertiesChainedProperty {
    private static final Logger logger = LoggerFactory.getLogger(HystrixPropertiesChainedProperty.class);

    private static <T> ChainBuilder<T> forType(final Class<T> type) {
        return new ChainBuilder<T>(){

            @Override
            protected Class<T> getType() {
                return type;
            }
        };
    }

    public static ChainBuilder<String> forString() {
        return HystrixPropertiesChainedProperty.forType(String.class);
    }

    public static ChainBuilder<Integer> forInteger() {
        return HystrixPropertiesChainedProperty.forType(Integer.class);
    }

    public static ChainBuilder<Boolean> forBoolean() {
        return HystrixPropertiesChainedProperty.forType(Boolean.class);
    }

    public static ChainBuilder<Long> forLong() {
        return HystrixPropertiesChainedProperty.forType(Long.class);
    }

    private static <T> HystrixDynamicProperty<T> getDynamicProperty(String propName, T defaultValue, Class<T> type) {
        HystrixDynamicProperties properties = HystrixPlugins.getInstance().getDynamicProperties();
        HystrixDynamicProperty<T> p = HystrixDynamicProperties.Util.getProperty(properties, propName, defaultValue, type);
        return p;
    }

    private static class ChainProperty<T>
    extends ChainLink<T> {
        private final HystrixDynamicProperty<T> sProp;

        public ChainProperty(HystrixDynamicProperty<T> sProperty) {
            this.sProp = sProperty;
        }

        public ChainProperty(HystrixDynamicProperty<T> sProperty, ChainProperty<T> next) {
            super(next);
            this.sProp = sProperty;
            this.sProp.addCallback(new Runnable(){

                @Override
                public void run() {
                    logger.debug("Property changed: '{} = {}'", (Object)ChainProperty.this.getName(), ChainProperty.this.getValue());
                    ChainProperty.this.checkAndFlip();
                }
            });
            this.checkAndFlip();
        }

        @Override
        public boolean isValueAcceptable() {
            return this.sProp.get() != null;
        }

        @Override
        protected T getValue() {
            return this.sProp.get();
        }

        @Override
        public String getName() {
            return this.sProp.getName();
        }
    }

    private static class ChainHystrixProperty<T>
    implements HystrixDynamicProperty<T> {
        private final ChainProperty<T> property;

        public ChainHystrixProperty(ChainProperty<T> property) {
            this.property = property;
        }

        @Override
        public String getName() {
            return this.property.getName();
        }

        @Override
        public T get() {
            return this.property.get();
        }

        @Override
        public void addCallback(Runnable callback) {
            this.property.addCallback(callback);
        }
    }

    public static abstract class ChainBuilder<T> {
        private List<HystrixDynamicProperty<T>> properties = new ArrayList<HystrixDynamicProperty<T>>();

        private ChainBuilder() {
        }

        public ChainBuilder<T> add(HystrixDynamicProperty<T> property) {
            this.properties.add(property);
            return this;
        }

        public ChainBuilder<T> add(String name, T defaultValue) {
            this.properties.add(HystrixPropertiesChainedProperty.getDynamicProperty(name, defaultValue, this.getType()));
            return this;
        }

        public HystrixDynamicProperty<T> build() {
            if (this.properties.size() < 1) {
                throw new IllegalArgumentException();
            }
            if (this.properties.size() == 1) {
                return this.properties.get(0);
            }
            ArrayList<HystrixDynamicProperty<T>> reversed = new ArrayList<HystrixDynamicProperty<T>>(this.properties);
            Collections.reverse(reversed);
            ChainProperty current = null;
            for (HystrixDynamicProperty hystrixDynamicProperty : reversed) {
                if (current == null) {
                    current = new ChainProperty(hystrixDynamicProperty);
                    continue;
                }
                current = new ChainProperty(hystrixDynamicProperty, current);
            }
            return new ChainHystrixProperty(current);
        }

        protected abstract Class<T> getType();
    }

    private static abstract class ChainLink<T> {
        private final AtomicReference<ChainLink<T>> pReference;
        private final ChainLink<T> next;
        private final List<Runnable> callbacks;

        public abstract String getName();

        protected abstract T getValue();

        public abstract boolean isValueAcceptable();

        public ChainLink() {
            this.next = null;
            this.pReference = new AtomicReference<ChainLink>(this);
            this.callbacks = new ArrayList<Runnable>();
        }

        public ChainLink(ChainLink<T> nextProperty) {
            this.next = nextProperty;
            this.pReference = new AtomicReference<ChainLink<T>>(this.next);
            this.callbacks = new ArrayList<Runnable>();
        }

        protected void checkAndFlip() {
            if (this.next == null) {
                this.pReference.set(this);
                return;
            }
            if (this.isValueAcceptable()) {
                logger.debug("Flipping property: {} to use its current value: {}", (Object)this.getName(), this.getValue());
                this.pReference.set(this);
            } else {
                logger.debug("Flipping property: {} to use NEXT property: {}", (Object)this.getName(), this.next);
                this.pReference.set(this.next);
            }
            for (Runnable r : this.callbacks) {
                r.run();
            }
        }

        public T get() {
            if (this.pReference.get() == this) {
                return this.getValue();
            }
            return this.pReference.get().get();
        }

        public void addCallback(Runnable r) {
            this.callbacks.add(r);
        }

        public String toString() {
            return this.getName() + " = " + this.get();
        }
    }
}

