/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.metric.HystrixCommandEvent;

public class HystrixCommandExecutionStarted
extends HystrixCommandEvent {
    private final HystrixCommandProperties.ExecutionIsolationStrategy isolationStrategy;
    private final int currentConcurrency;

    public HystrixCommandExecutionStarted(HystrixCommandKey commandKey, HystrixThreadPoolKey threadPoolKey, HystrixCommandProperties.ExecutionIsolationStrategy isolationStrategy, int currentConcurrency) {
        super(commandKey, threadPoolKey);
        this.isolationStrategy = isolationStrategy;
        this.currentConcurrency = currentConcurrency;
    }

    @Override
    public boolean isExecutionStart() {
        return true;
    }

    @Override
    public boolean isExecutedInThread() {
        return this.isolationStrategy.equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD);
    }

    @Override
    public boolean isResponseThreadPoolRejected() {
        return false;
    }

    @Override
    public boolean isCommandCompletion() {
        return false;
    }

    @Override
    public boolean didCommandExecute() {
        return false;
    }

    public int getCurrentConcurrency() {
        return this.currentConcurrency;
    }
}

