/*
 * Decompiled with CFR 0.152.
 */
package com.pongsky.kit.springfox.config;

import com.pongsky.kit.springfox.properties.SpringFoxProperties;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import springfox.documentation.RequestHandler;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

@ConditionalOnProperty(value={"doc.enabled"}, havingValue="true", matchIfMissing=true)
public class SpringFoxConfig {
    private final SpringFoxProperties properties;
    private final ApplicationContext applicationContext;

    @Bean
    public Docket defaultDocket() {
        List securitySchemes = this.properties.getRequestParameters().entrySet().stream().map(e -> ((List)e.getValue()).stream().map(v -> new ApiKey(v, v, ((SpringFoxProperties.AuthIn)((Object)((Object)((Object)e.getKey())))).name())).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        List collect = this.properties.getRequestParameters().values().stream().flatMap(Collection::stream).map(v -> SecurityReference.builder().reference(v).scopes(new AuthorizationScope[]{new AuthorizationScope("global", "accessAnything")}).build()).collect(Collectors.toList());
        List<SecurityContext> securityContexts = Collections.singletonList(SecurityContext.builder().securityReferences(collect).build());
        if (this.properties.getGroups().size() == 0) {
            return new Docket(DocumentationType.OAS_30).apiInfo(new ApiInfoBuilder().title(this.properties.getTitle()).description(this.properties.getDescription()).version(this.properties.getVersion()).build()).select().apis(SpringFoxConfig.withMethodAnnotation()).paths(PathSelectors.any()).build().securitySchemes(securitySchemes).securityContexts(securityContexts);
        }
        List displayNames = this.properties.getGroups().stream().map(SpringFoxProperties.GroupOpenApi::getDisplayName).collect(Collectors.groupingBy(v -> v, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (displayNames.size() > 0) {
            throw new IllegalArgumentException(MessageFormat.format("\u7ec4\u522b\u540d\u79f0 displayName {0} \u51fa\u73b0\u91cd\u590d", displayNames));
        }
        List groups = this.properties.getGroups().stream().map(SpringFoxProperties.GroupOpenApi::getGroup).collect(Collectors.groupingBy(v -> v, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (groups.size() > 0) {
            throw new IllegalArgumentException(MessageFormat.format("\u7ec4\u522b\u8def\u5f84 group {0} \u51fa\u73b0\u91cd\u590d", groups));
        }
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        Docket defaultDocket = null;
        for (int i = 0; i < this.properties.getGroups().size(); ++i) {
            SpringFoxProperties.GroupOpenApi groupOpenApi = this.properties.getGroups().get(i);
            Docket docket = new Docket(DocumentationType.OAS_30).apiInfo(new ApiInfoBuilder().title(this.properties.getTitle()).description(this.properties.getDescription()).version(this.properties.getVersion()).build()).select().apis(SpringFoxConfig.withMethodAnnotation()).paths(PathSelectors.any()).build().groupName(groupOpenApi.getDisplayName()).securitySchemes(securitySchemes).securityContexts(securityContexts);
            if (i == 0) {
                defaultDocket = docket;
                continue;
            }
            beanFactory.registerSingleton(MessageFormat.format("{0}-Docket", groupOpenApi.getDisplayName()), (Object)docket);
        }
        return defaultDocket;
    }

    private static Predicate<RequestHandler> withMethodAnnotation() {
        return input -> input.isAnnotatedWith(ApiOperation.class) || input.isAnnotatedWith(Operation.class);
    }

    public SpringFoxConfig(SpringFoxProperties properties, ApplicationContext applicationContext) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }
}

