/*
 * Decompiled with CFR 0.152.
 */
package com.pongsky.kit.springfox.config;

import com.pongsky.kit.springfox.properties.SpringFoxProperties;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Primary;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Primary
@ConditionalOnProperty(value={"doc.enabled"}, havingValue="true", matchIfMissing=true)
public class SwaggerResourceConfig
implements SwaggerResourcesProvider {
    private static final Logger log = LoggerFactory.getLogger(SwaggerResourceConfig.class);
    private final SpringFoxProperties properties;
    private static final String DEFAULT_SWAGGER_URL = "/v3/api-docs";
    private static final String SWAGGER_URL = "/v3/api-docs{0}";
    private static final List<SwaggerResource> RESOURCES = new ArrayList<SwaggerResource>();

    public List<SwaggerResource> get() {
        if (RESOURCES.size() > 0) {
            return RESOURCES;
        }
        if (this.properties.getGroups().size() == 0) {
            RESOURCES.add(this.buildSwaggerResource("default", DEFAULT_SWAGGER_URL));
        } else {
            RESOURCES.addAll(this.properties.getGroups().stream().map(g -> this.buildSwaggerResource(g.getDisplayName(), MessageFormat.format(SWAGGER_URL, g.getGroup()))).collect(Collectors.toList()));
        }
        return RESOURCES;
    }

    private SwaggerResource buildSwaggerResource(String name, String url) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setUrl(url);
        return swaggerResource;
    }

    public SwaggerResourceConfig(SpringFoxProperties properties) {
        this.properties = properties;
    }
}

