/*
 * Decompiled with CFR 0.152.
 */
package com.pongsky.kit.springfox.properties;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="doc")
public class SpringFoxProperties {
    private boolean enabled = true;
    private boolean gatewayRouteEnabled = false;
    private String title = "API Docs";
    private String description;
    private String version;
    private Map<AuthIn, List<String>> requestParameters = Collections.emptyMap();
    @Valid
    private List<GroupOpenApi> groups = Collections.emptyList();

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isGatewayRouteEnabled() {
        return this.gatewayRouteEnabled;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public Map<AuthIn, List<String>> getRequestParameters() {
        return this.requestParameters;
    }

    public List<GroupOpenApi> getGroups() {
        return this.groups;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setGatewayRouteEnabled(boolean gatewayRouteEnabled) {
        this.gatewayRouteEnabled = gatewayRouteEnabled;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setRequestParameters(Map<AuthIn, List<String>> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public void setGroups(List<GroupOpenApi> groups) {
        this.groups = groups;
    }

    public static class GroupOpenApi {
        @NotBlank
        private String displayName;
        @NotNull
        private String group;

        public String getDisplayName() {
            return this.displayName;
        }

        public String getGroup() {
            return this.group;
        }

        public GroupOpenApi setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public GroupOpenApi setGroup(String group) {
            this.group = group;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupOpenApi)) {
                return false;
            }
            GroupOpenApi other = (GroupOpenApi)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$group = this.getGroup();
            String other$group = other.getGroup();
            return !(this$group == null ? other$group != null : !this$group.equals(other$group));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GroupOpenApi;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $group = this.getGroup();
            result = result * 59 + ($group == null ? 43 : $group.hashCode());
            return result;
        }
    }

    public static enum AuthIn {
        header,
        query,
        cookie;

    }
}

