/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Hash;
import com.sap.db.jdbc.HashPartitionInfo;
import com.sap.db.jdbc.PartitionParameterInfo;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.RangeInfo;
import com.sap.db.jdbc.RangePartitionInfo;
import com.sap.db.jdbc.RangeVoteCentre;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.SiteTypeVolumeID;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.packet.HPartInfo;
import com.sap.db.jdbc.packet.PartitionMethod;
import com.sap.db.jdbc.packet.PartitionParameterFunction;
import com.sap.db.jdbc.packet.RangeComparisonFunction;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.CharsetUtils;
import com.sap.db.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@NotThreadSafe
class PartitionInformationTree {
    private static final ThreadLocal<Calendar> CALENDAR = new ThreadLocal<Calendar>(){

        @Override
        public Calendar initialValue() {
            return Calendar.getInstance();
        }
    };
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT = new ThreadLocal<DecimalFormat>(){

        @Override
        public DecimalFormat initialValue() {
            DecimalFormat decimalFormat = new DecimalFormat();
            decimalFormat.setMinimumIntegerDigits(1);
            decimalFormat.setDecimalSeparatorAlwaysShown(false);
            decimalFormat.setGroupingUsed(false);
            return decimalFormat;
        }
    };
    private final Tracer _tracer;
    private final List<PartitionInformationTreeNode> _treeNodes = new ArrayList<PartitionInformationTreeNode>();
    private final Map<Integer, List<PartitionMethod>> _partitionParamTypeMap = new HashMap<Integer, List<PartitionMethod>>();
    private List<AbstractConverter> _parameterConverters;
    private List<Object> _rawInputHashArgs = new ArrayList<Object>();
    private List<Object> _rawInputRangeArgs = new ArrayList<Object>();
    private boolean _hashPartitioned;
    private boolean _rangePartitioned;
    private int _volumeIDAffinity = 5;
    private int _expectedTreeNodeCount = 1;

    PartitionInformationTree(Tracer tracer) throws IllegalArgumentException {
        this._tracer = tracer;
    }

    void addPartitionInformationNode(HPartInfo partInfo, Map<Byte, SiteType> siteIDToSiteTypeMap) {
        this._tracer.printDebugMessage(this.toString() + ": addPartitionInformationNode");
        try {
            if (this._isComplete()) {
                this._tracer.printDebugMessage(this.toString() + ": addPartitionInformationNode - Ignoring new tree information as the tree is already complete");
                return;
            }
            switch (partInfo.getPartitionMethod()) {
                case Hash: 
                case HashWithoutSplitBatch: {
                    HashPartitionInfo hashPartitionInfo = partInfo.getHashPartitionInfo(siteIDToSiteTypeMap);
                    this._treeNodes.add(new PartitionInformationHashNode(this._tracer, hashPartitionInfo, this, partInfo.getPartitionMethod()));
                    break;
                }
                case Range: 
                case RangeWithoutSplitBatch: {
                    RangePartitionInfo rangePartitionInfo = partInfo.getRangePartitionInfo(siteIDToSiteTypeMap);
                    this._treeNodes.add(new PartitionInformationRangeNode(this._tracer, rangePartitionInfo, this, partInfo.getPartitionMethod()));
                    break;
                }
                case RoundRobin: {
                    break;
                }
                default: {
                    this._tracer.printDebugMessage(this.toString() + ": addPartitionInformationNode - unknown PartitionMethod found: " + partInfo.getPartitionMethod().toString());
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (IllegalArgumentException ex) {
            this._tracer.printDebugMessage(this.toString() + ": addPartitionInformationNode - could not add new node: " + ex.getMessage());
        }
    }

    int getVolumeIDAffinity() {
        return this._volumeIDAffinity;
    }

    PartitionMethod getPartitionMethod() {
        if (this._treeNodes.isEmpty()) {
            return PartitionMethod.None;
        }
        return this._treeNodes.get(0).getPartitionMethod();
    }

    SiteTypeVolumeID getFirstPartitionVolumeID() {
        if (!this._isComplete()) {
            throw new IllegalArgumentException("The Partition Tree is not complete");
        }
        return this._treeNodes.get(0).getFirstPartitionVolumeID();
    }

    void setParameterConverters(List<AbstractConverter> parameterConverters) {
        if (parameterConverters != null && !parameterConverters.isEmpty()) {
            this._parameterConverters = parameterConverters;
            int numberOfParameterConverters = parameterConverters.size();
            int currentRawInputArgsSize = this._rawInputHashArgs.size();
            if (currentRawInputArgsSize != numberOfParameterConverters) {
                for (int i = 0; i < numberOfParameterConverters - currentRawInputArgsSize; ++i) {
                    this._rawInputHashArgs.add(PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                    this._rawInputRangeArgs.add(PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                }
            }
        }
    }

    void setUninitialized(int parameterIndex) {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
    }

    void setByteShortIntLongForHashPartitionCalculation(boolean forByte, int parameterIndex, long x) {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        if (this._isHashPartitionParameter(parameterIndex)) {
            AbstractConverter converter = this._parameterConverters.get(parameterIndex - 1);
            switch (converter.getColumnType()) {
                case -6: {
                    this._rawInputHashArgs.set(parameterIndex - 1, String.valueOf(forByte ? x & 0xFFL : x));
                    break;
                }
                case -15: 
                case -9: 
                case -5: 
                case 4: 
                case 5: 
                case 12: {
                    this._rawInputHashArgs.set(parameterIndex - 1, String.valueOf(x));
                    break;
                }
                case 3: {
                    this._rawInputHashArgs.set(parameterIndex - 1, this._translateDecimalForHashing(new BigDecimal(x), parameterIndex));
                    break;
                }
                case -3: 
                case -2: {
                    if (forByte) {
                        this._rawInputHashArgs.set(parameterIndex - 1, new byte[]{(byte)x});
                        break;
                    }
                    this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                    break;
                }
                default: {
                    this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                    break;
                }
            }
        } else {
            this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    void setByteShortIntLongForRangePartitionCalculation(int parameterIndex, long x) {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        if (this._isRangePartitionParameter(parameterIndex)) {
            AbstractConverter converter = this._parameterConverters.get(parameterIndex - 1);
            switch (converter.getColumnType()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    this._rawInputRangeArgs.set(parameterIndex - 1, x);
                    break;
                }
                case 3: {
                    this._rawInputRangeArgs.set(parameterIndex - 1, new BigDecimal(x));
                    break;
                }
                case -15: 
                case -9: 
                case 12: {
                    this._rawInputRangeArgs.set(parameterIndex - 1, String.valueOf(x));
                    break;
                }
                default: {
                    this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                    break;
                }
            }
        } else {
            this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    void setDoubleForHashPartitionCalculation(int parameterIndex, double x) throws SQLException {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        if (this._isHashPartitionParameter(parameterIndex)) {
            AbstractConverter converter = this._parameterConverters.get(parameterIndex - 1);
            switch (converter.getColumnType()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    this._rawInputHashArgs.set(parameterIndex - 1, String.valueOf((long)x));
                    break;
                }
                case 3: {
                    if (converter.getScale() == 0) {
                        this._rawInputHashArgs.set(parameterIndex - 1, this._translateDecimalForHashing(String.valueOf((long)x), parameterIndex));
                        break;
                    }
                    this._rawInputHashArgs.set(parameterIndex - 1, this._translateDecimalForHashing(String.valueOf(x), parameterIndex));
                    break;
                }
                case -15: 
                case -9: 
                case 12: {
                    this._rawInputHashArgs.set(parameterIndex - 1, StringUtils.DECIMAL_FORMAT.get().format(x));
                    break;
                }
                default: {
                    this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                    break;
                }
            }
        } else {
            this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    void setDoubleForRangePartitionCalculation(int parameterIndex, double x) throws SQLException {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        if (this._isRangePartitionParameter(parameterIndex)) {
            AbstractConverter converter = this._parameterConverters.get(parameterIndex - 1);
            switch (converter.getColumnType()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    this._rawInputRangeArgs.set(parameterIndex - 1, (long)x);
                    break;
                }
                case 3: {
                    if (converter.getScale() == 0) {
                        this._rawInputRangeArgs.set(parameterIndex - 1, new BigDecimal((long)x));
                        break;
                    }
                    Object obj = this._translateDecimalForHashing(String.valueOf(x), parameterIndex);
                    this._rawInputRangeArgs.set(parameterIndex - 1, obj == PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE ? PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE : new BigDecimal((String)obj));
                    break;
                }
                case -15: 
                case -9: 
                case 12: {
                    this._rawInputRangeArgs.set(parameterIndex - 1, String.valueOf(x));
                    break;
                }
                default: {
                    this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                    break;
                }
            }
        } else {
            this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    void setBigDecimalForHashPartitionCalculation(int parameterIndex, BigDecimal x) {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        if (this._isHashPartitionParameter(parameterIndex)) {
            AbstractConverter converter = this._parameterConverters.get(parameterIndex - 1);
            if (x == null) {
                this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
            } else {
                switch (converter.getColumnType()) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        this._rawInputHashArgs.set(parameterIndex - 1, String.valueOf(x.longValue()));
                        break;
                    }
                    case 3: {
                        this._rawInputHashArgs.set(parameterIndex - 1, this._translateDecimalForHashing(x, parameterIndex));
                        break;
                    }
                    default: {
                        this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                    }
                }
            }
        } else {
            this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    void setBigDecimalForRangePartitionCalculation(int parameterIndex, BigDecimal x) {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        if (this._isRangePartitionParameter(parameterIndex)) {
            AbstractConverter converter = this._parameterConverters.get(parameterIndex - 1);
            if (x == null) {
                this._rawInputRangeArgs.set(parameterIndex - 1, null);
            } else {
                switch (converter.getColumnType()) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        try {
                            this._rawInputRangeArgs.set(parameterIndex - 1, x.longValue());
                        }
                        catch (NumberFormatException e) {
                            this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                        }
                        break;
                    }
                    case 3: {
                        this._rawInputRangeArgs.set(parameterIndex - 1, x.setScale(converter.getScale(), RoundingMode.FLOOR));
                        break;
                    }
                    default: {
                        this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                    }
                }
            }
        } else {
            this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    void setTimestampForHashPartitionCalculation(int parameterIndex, Timestamp x) {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        if (this._isHashPartitionParameter(parameterIndex)) {
            AbstractConverter converter = this._parameterConverters.get(parameterIndex - 1);
            if (converter.getColumnType() == 93) {
                this._rawInputHashArgs.set(parameterIndex - 1, x.toString());
            } else {
                this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
            }
        } else {
            this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    void setTimestampForRangePartitionCalculation(int parameterIndex, Timestamp x) {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        if (this._isRangePartitionParameter(parameterIndex)) {
            AbstractConverter converter = this._parameterConverters.get(parameterIndex - 1);
            if (x == null) {
                this._rawInputRangeArgs.set(parameterIndex - 1, null);
            } else if (converter.getColumnType() == 93) {
                this._rawInputRangeArgs.set(parameterIndex - 1, x);
            } else {
                this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
            }
        } else {
            this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    void setStringForHashPartitionCalculation(int parameterIndex, String x) {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        if (this._isHashPartitionParameter(parameterIndex)) {
            if (x == null) {
                this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
            } else {
                AbstractConverter converter = this._parameterConverters.get(parameterIndex - 1);
                switch (converter.getColumnType()) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        this._rawInputHashArgs.set(parameterIndex - 1, x.trim().replaceFirst("^(?:(-)|\\+)?0*(?!$)", "$1"));
                        break;
                    }
                    case 3: {
                        this._rawInputHashArgs.set(parameterIndex - 1, this._translateDecimalForHashing(x.trim(), parameterIndex));
                        break;
                    }
                    case 93: {
                        x = x.trim();
                        if (x.contains(" .") || x.contains(". ")) {
                            this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                            break;
                        }
                        this._rawInputHashArgs.set(parameterIndex - 1, x);
                        break;
                    }
                    case -15: 
                    case -9: 
                    case 12: {
                        this._rawInputHashArgs.set(parameterIndex - 1, x);
                        break;
                    }
                    default: {
                        this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                        break;
                    }
                }
            }
        } else {
            this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    void setStringForRangePartitionCalculation(int parameterIndex, String x) {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        if (this._isRangePartitionParameter(parameterIndex)) {
            if (x == null) {
                this._rawInputRangeArgs.set(parameterIndex - 1, null);
            } else {
                AbstractConverter converter = this._parameterConverters.get(parameterIndex - 1);
                switch (converter.getColumnType()) {
                    case -6: 
                    case -5: 
                    case 4: 
                    case 5: {
                        x = x.trim();
                        try {
                            this._rawInputRangeArgs.set(parameterIndex - 1, Long.valueOf(x));
                        }
                        catch (NumberFormatException e) {
                            try {
                                x = x.replaceAll("[^0-9-.]", "");
                                this._rawInputRangeArgs.set(parameterIndex - 1, Long.valueOf(x));
                            }
                            catch (NumberFormatException e1) {
                                this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                            }
                        }
                        break;
                    }
                    case 3: {
                        try {
                            this._rawInputRangeArgs.set(parameterIndex - 1, new BigDecimal(x.trim()));
                        }
                        catch (NumberFormatException e) {
                            this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                        }
                        break;
                    }
                    case 93: {
                        try {
                            this._rawInputRangeArgs.set(parameterIndex - 1, Timestamp.valueOf(x.trim()));
                        }
                        catch (IllegalArgumentException e) {
                            this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                        }
                        break;
                    }
                    case -15: 
                    case -9: 
                    case 12: {
                        this._rawInputRangeArgs.set(parameterIndex - 1, x);
                        break;
                    }
                    default: {
                        this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                    }
                }
            }
        } else {
            this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    void setBytesForHashPartitionCalculation(int parameterIndex, byte[] x) {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        if (this._isHashPartitionParameter(parameterIndex)) {
            if (x == null) {
                this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
            } else {
                AbstractConverter converter = this._parameterConverters.get(parameterIndex - 1);
                switch (converter.getColumnType()) {
                    case -3: 
                    case -2: {
                        this._rawInputHashArgs.set(parameterIndex - 1, new String(x, CharsetUtils.UTF_8));
                        break;
                    }
                    default: {
                        this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
                        break;
                    }
                }
            }
        } else {
            this._rawInputHashArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    void setBytesForRangePartitionCalculation(int parameterIndex) {
        if (this._isInvalidParameterIndex(parameterIndex)) {
            return;
        }
        if (this._isRangePartitionParameter(parameterIndex)) {
            this._rawInputRangeArgs.set(parameterIndex - 1, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    SiteTypeVolumeID computeSiteTypeVolumeID() {
        SiteTypeVolumeID siteTypeVolumeID;
        this._tracer.printDebugMessage(this.toString() + "computeSiteTypeVolumeID");
        try {
            if (this._noParameters()) {
                throw new IllegalArgumentException("List of parameter converters cannot be null or empty");
            }
            if (!this._isComplete()) {
                throw new IllegalArgumentException("The tree is not complete");
            }
            siteTypeVolumeID = this._treeNodes.get(0).computeSiteTypeVolumeID();
        }
        catch (Exception ex) {
            this._tracer.printDebugMessage(this.toString() + ": Could not compute SiteVolumeID: " + ex.getMessage());
            siteTypeVolumeID = new SiteTypeVolumeID(SiteType.NONE, -1);
        }
        return siteTypeVolumeID;
    }

    boolean isHashPartitioned() {
        return this._hashPartitioned;
    }

    boolean isRangePartitioned() {
        return this._rangePartitioned;
    }

    void clearParametersForPartitionCalculation() {
        if (this._noParameters()) {
            return;
        }
        int n = this._parameterConverters.size();
        for (int i = 0; i < n; ++i) {
            this._rawInputHashArgs.set(i, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
            this._rawInputRangeArgs.set(i, PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE);
        }
    }

    private boolean _isInvalidParameterIndex(int parameterIndex) {
        return this._noParameters() || parameterIndex < 0 || parameterIndex > this._parameterConverters.size();
    }

    private boolean _noParameters() {
        return this._parameterConverters == null || this._parameterConverters.isEmpty();
    }

    private boolean _isHashPartitionParameter(int parameterIndex) {
        List<PartitionMethod> partitionMethods = this._partitionParamTypeMap.get(parameterIndex);
        return partitionMethods != null && (partitionMethods.contains((Object)PartitionMethod.Hash) || partitionMethods.contains((Object)PartitionMethod.HashWithoutSplitBatch));
    }

    private boolean _isRangePartitionParameter(int parameterIndex) {
        List<PartitionMethod> partitionMethods = this._partitionParamTypeMap.get(parameterIndex);
        return partitionMethods != null && (partitionMethods.contains((Object)PartitionMethod.Range) || partitionMethods.contains((Object)PartitionMethod.RangeWithoutSplitBatch));
    }

    private int _getNumberOfTreeNodes() {
        return this._treeNodes.size();
    }

    private void _incrementExpectedNumberOfTreeNodes() {
        ++this._expectedTreeNodeCount;
    }

    private PartitionInformationTreeNode _getTreeNode(int partitionIndex) {
        return this._treeNodes.get(partitionIndex);
    }

    private boolean _isComplete() {
        return !this._treeNodes.isEmpty() && this._treeNodes.size() >= this._expectedTreeNodeCount;
    }

    private void _addNewPartitionMethodForParameters(List<PartitionParameterInfo> partitionParameterInfoList, PartitionMethod newPartitionMethod) {
        if (partitionParameterInfoList == null || partitionParameterInfoList.isEmpty()) {
            return;
        }
        switch (newPartitionMethod) {
            case Hash: 
            case HashWithoutSplitBatch: {
                this._hashPartitioned = true;
                break;
            }
            case Range: 
            case RangeWithoutSplitBatch: {
                this._rangePartitioned = true;
                break;
            }
        }
        for (PartitionParameterInfo partitionParameterInfo : partitionParameterInfoList) {
            List<PartitionMethod> partitionMethods = this._partitionParamTypeMap.get(partitionParameterInfo.getParameterIndex());
            if (partitionMethods == null) {
                partitionMethods = new ArrayList<PartitionMethod>();
                partitionMethods.add(newPartitionMethod);
                this._partitionParamTypeMap.put(partitionParameterInfo.getParameterIndex(), partitionMethods);
                continue;
            }
            if (partitionMethods.contains((Object)newPartitionMethod)) continue;
            partitionMethods.add(newPartitionMethod);
        }
    }

    private Object _translateDecimalForHashing(BigDecimal bigDecimal, int parameterIndex) {
        int scale = this._parameterConverters.get(parameterIndex - 1).getScale();
        if (bigDecimal.scale() > scale) {
            return PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE;
        }
        DecimalFormat decimalFormat = DECIMAL_FORMAT.get();
        decimalFormat.setMaximumFractionDigits(scale);
        decimalFormat.setMinimumFractionDigits(scale);
        return decimalFormat.format(bigDecimal);
    }

    private Object _translateDecimalForHashing(String s, int parameterIndex) {
        if (s.trim().isEmpty()) {
            return PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE;
        }
        return this._translateDecimalForHashing(new BigDecimal(s), parameterIndex);
    }

    void setVolumeIDAffinity(int volumeIDAffinity) {
        this._volumeIDAffinity = volumeIDAffinity;
    }

    HashPartitionInfo getHashPartitionInfo() {
        if (this._isComplete() && this.getPartitionMethod() == PartitionMethod.Hash || this.getPartitionMethod() == PartitionMethod.HashWithoutSplitBatch) {
            return ((PartitionInformationHashNode)this._treeNodes.get(0)).getHashPartitionInfo();
        }
        return null;
    }

    RangePartitionInfo getRangePartitionInfo() {
        if (this._isComplete() && this.getPartitionMethod() == PartitionMethod.Range || this.getPartitionMethod() == PartitionMethod.RangeWithoutSplitBatch) {
            return ((PartitionInformationRangeNode)this._treeNodes.get(0)).getRangePartitionInfo();
        }
        return null;
    }

    private class PartitionInformationRangeNode
    extends PartitionInformationTreeNode {
        private final Map<RangeInfo, Integer> _rangePartitionToNodeIndex;
        private final Map<RangeInfo, SiteTypeVolumeIDRotationList> _rangeInfoToRotationList;
        private final RangePartitionInfo _rangePartitionInfo;

        private PartitionInformationRangeNode(Tracer tracer, RangePartitionInfo rangePartitionInfo, PartitionInformationTree hostingTree, PartitionMethod partitionMethod) {
            super(tracer, hostingTree, partitionMethod);
            this._rangePartitionToNodeIndex = new HashMap<RangeInfo, Integer>();
            this._rangeInfoToRotationList = new HashMap<RangeInfo, SiteTypeVolumeIDRotationList>();
            if (rangePartitionInfo == null) {
                throw new IllegalArgumentException("RangePartitionInfo cannot be null");
            }
            this._rangePartitionInfo = rangePartitionInfo;
            this.tracePartitionInformation();
            int numberOfTreeNodes = hostingTree._getNumberOfTreeNodes();
            for (RangeInfo rangeInfo : this._rangePartitionInfo.getRangeInfoList()) {
                boolean isSubpartition = false;
                List<SiteTypeVolumeID> siteTypeVolumeIDs = rangeInfo.getSiteTypeVolumeIDs();
                for (SiteTypeVolumeID siteTypeVolumeID : siteTypeVolumeIDs) {
                    if (!siteTypeVolumeID.isSubpartition()) continue;
                    if (siteTypeVolumeIDs.size() > 1 || isSubpartition) {
                        throw new IllegalArgumentException("Cannot have aggregate volume IDs for a subpartition");
                    }
                    isSubpartition = true;
                }
                if (isSubpartition) {
                    this.getHostingTree()._incrementExpectedNumberOfTreeNodes();
                    this._rangePartitionToNodeIndex.put(rangeInfo, ++numberOfTreeNodes);
                    continue;
                }
                this._rangeInfoToRotationList.put(rangeInfo, new SiteTypeVolumeIDRotationList(siteTypeVolumeIDs, this.getHostingTree().getVolumeIDAffinity()));
                this._rangePartitionToNodeIndex.put(rangeInfo, null);
            }
            this.getHostingTree()._addNewPartitionMethodForParameters(this._rangePartitionInfo.getPartitionParameterInfoList(), partitionMethod);
        }

        @Override
        SiteTypeVolumeID computeSiteTypeVolumeID() throws SQLException {
            this._tracer.printDebugMessage(this.toString() + ": computeSiteTypeVolumeID");
            int parameterCount = this._rangePartitionInfo.getParameterCount();
            int rangeCount = this._rangePartitionInfo.getRangeCount();
            List<PartitionParameterInfo> partitionParameterInfoList = this._rangePartitionInfo.getPartitionParameterInfoList();
            List<RangeInfo> rangeInfoList = this._rangePartitionInfo.getRangeInfoList();
            List parameterConverters = this.getHostingTree()._parameterConverters;
            List rawInputArgs = this.getHostingTree()._rawInputRangeArgs;
            if (parameterCount <= 0 || rangeCount <= 0 || parameterConverters == null || parameterCount > parameterConverters.size() || partitionParameterInfoList == null || partitionParameterInfoList.size() != parameterCount || rangeInfoList.size() != rangeCount) {
                return new SiteTypeVolumeID(SiteType.NONE, -1);
            }
            RangeVoteCentre voteCentre = new RangeVoteCentre();
            for (PartitionParameterInfo partitionParameterInfo : partitionParameterInfoList) {
                Object[] value;
                if (!this._getValuePreparedForComparision(parameterConverters, rawInputArgs, partitionParameterInfo, value = new Object[1])) continue;
                this._doVotingForPartition(partitionParameterInfo, voteCentre, rangeCount, rangeInfoList, parameterConverters, value[0]);
            }
            RangeInfo topRangeInfo = voteCentre.getTopRangeInfo();
            if (topRangeInfo != null) {
                if (this._isSubpartition(topRangeInfo)) {
                    Integer subPartitionNodeIndex = this._rangePartitionToNodeIndex.get(topRangeInfo);
                    this._tracer.printDebugMessage(this.toString() + "Subpartitioning range " + topRangeInfo.toString() + " to Partition Tree node " + subPartitionNodeIndex);
                    return this.getHostingTree()._getTreeNode(subPartitionNodeIndex).computeSiteTypeVolumeID();
                }
            } else {
                throw new IllegalArgumentException("Top range info was found to be null");
            }
            SiteTypeVolumeID siteTypeVolumeID = this._selectSiteTypeVolumeIDFromList(topRangeInfo);
            if (siteTypeVolumeID.getSiteType() == SiteType.NONE && siteTypeVolumeID.getVolumeID() == -1) {
                throw new IllegalArgumentException("Invalid SiteTypeVolumeID selected");
            }
            return siteTypeVolumeID;
        }

        @Override
        SiteTypeVolumeID getFirstPartitionVolumeID() throws IllegalArgumentException {
            if (!PartitionInformationTree.this._isComplete()) {
                throw new IllegalArgumentException("The Partition Tree is not complete");
            }
            RangeInfo rangeInfo = this._rangePartitionInfo.getRangeInfoList().get(0);
            List<SiteTypeVolumeID> siteTypeVolumeIDs = rangeInfo.getSiteTypeVolumeIDs();
            SiteTypeVolumeID siteTypeVolumeID = siteTypeVolumeIDs.get(0);
            if (siteTypeVolumeID.isSubpartition()) {
                Integer subPartitionNodeIndex = this._rangePartitionToNodeIndex.get(rangeInfo);
                return this.getHostingTree()._getTreeNode(subPartitionNodeIndex).getFirstPartitionVolumeID();
            }
            return siteTypeVolumeID;
        }

        @Override
        void tracePartitionInformation() {
            if (!this._tracer.getTraceConfiguration().getTraceLevel().get(5) || this._rangePartitionInfo == null) {
                return;
            }
            String lineSeparator = System.getProperty("line.separator");
            String traceString = this.toString() + ": Partitioning at Tree Node[" + this.getHostingTree()._getNumberOfTreeNodes() + "]" + lineSeparator + this._rangePartitionInfo._toString(this.getHostingTree()._getNumberOfTreeNodes());
            this._tracer.printDebugMessage(traceString);
        }

        @Override
        PartitionMethod getPartitionMethod() {
            return PartitionMethod.Range;
        }

        private boolean _isSubpartition(RangeInfo rangeInfo) {
            Integer subPartitionNodeIndex = this._rangePartitionToNodeIndex.get(rangeInfo);
            return subPartitionNodeIndex != null;
        }

        private boolean _getValuePreparedForComparision(List<AbstractConverter> parameterConverters, List<Object> rawInputArgs, PartitionParameterInfo partitionParameterInfo, Object[] returnValue) throws IllegalArgumentException {
            int parameterIndex = partitionParameterInfo.getParameterIndex();
            if (parameterIndex < 0 || parameterIndex > parameterConverters.size()) {
                this._tracer.printDebugMessage(this.toString() + "Invalid parameter index: " + parameterIndex);
                throw new IllegalArgumentException();
            }
            boolean shouldVote = true;
            Object value = rawInputArgs.get(parameterIndex - 1);
            if (value == null) {
                returnValue[0] = null;
                return shouldVote;
            }
            if (value == PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE) {
                shouldVote = false;
                returnValue[0] = value;
                return shouldVote;
            }
            switch (parameterConverters.get(parameterIndex - 1).getColumnType()) {
                case 93: {
                    PartitionParameterFunction partitionParameterFunction = partitionParameterInfo.getPartitionParameterFunction();
                    Timestamp timestamp = (Timestamp)value;
                    String timestampString = this._convertTimestampForPartitioning(timestamp.toString(), partitionParameterFunction, false);
                    if (timestampString == null) {
                        shouldVote = false;
                        return shouldVote;
                    }
                    value = Long.valueOf(timestampString);
                    break;
                }
                case -15: {
                    if (partitionParameterInfo.getAttributeType() != 67) break;
                    value = ((String)value).replaceAll("\\s+$", "");
                }
            }
            returnValue[0] = value;
            return shouldVote;
        }

        private void _doVotingForPartition(PartitionParameterInfo partitionParameterInfo, RangeVoteCentre voteCentre, int rangeCount, List<RangeInfo> rangeInfoList, List<AbstractConverter> parameterConverters, Object value) throws SQLException {
            if (value == null) {
                RangeInfo rangeInfo = rangeInfoList.get(rangeCount - 1);
                if (rangeInfo.isRestRange()) {
                    voteCentre.vote(rangeCount - 1, rangeInfo);
                }
                return;
            }
            if (value == PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE) {
                return;
            }
            int parameterIndex = partitionParameterInfo.getParameterIndex();
            boolean expressVoting = false;
            boolean done = false;
            RangeComparisonFunction rangeComparisonFunction = partitionParameterInfo.getRangeComparisonFunction();
            block8: for (int j = 0; j < rangeCount && !done; ++j) {
                RangeInfo rangeInfo = rangeInfoList.get(j);
                if (expressVoting) {
                    voteCentre.vote(j, rangeInfo);
                    continue;
                }
                switch (rangeComparisonFunction) {
                    case EQ: {
                        if (!this._rangeEqualComparison(rangeInfo, value, parameterConverters, parameterIndex)) continue block8;
                        voteCentre.vote(j, rangeInfo);
                        done = true;
                        continue block8;
                    }
                    case LE: {
                        if (this._rangeLessThanEqualComparison(rangeInfo, value, parameterConverters, parameterIndex)) {
                            voteCentre.vote(j, rangeInfo);
                            continue block8;
                        }
                        RangeInfo lastRangeInfo = rangeInfoList.get(rangeCount - 1);
                        if (lastRangeInfo.isRestRange()) {
                            voteCentre.vote(rangeCount - 1, lastRangeInfo);
                        }
                        done = true;
                        continue block8;
                    }
                    case LT: {
                        if (this._rangeLessThanComparison(rangeInfo, value, parameterConverters, parameterIndex)) {
                            voteCentre.vote(j, rangeInfo);
                            continue block8;
                        }
                        RangeInfo lastRangeInfo = rangeInfoList.get(rangeCount - 1);
                        if (lastRangeInfo.isRestRange()) {
                            voteCentre.vote(rangeCount - 1, lastRangeInfo);
                        }
                        done = true;
                        continue block8;
                    }
                    case GE: {
                        if (!this._rangeGreaterThanEqualComparison(rangeInfo, value, parameterConverters, parameterIndex)) continue block8;
                        voteCentre.vote(j, rangeInfo);
                        expressVoting = true;
                        continue block8;
                    }
                    case GT: {
                        if (!this._rangeGreaterThanComparison(rangeInfo, value, parameterConverters, parameterIndex)) continue block8;
                        voteCentre.vote(j, rangeInfo);
                        expressVoting = true;
                        continue block8;
                    }
                    case NE: {
                        if (this._rangeLessThanComparison(rangeInfo, value, parameterConverters, parameterIndex) || this._rangeGreaterThanComparison(rangeInfo, value, parameterConverters, parameterIndex)) {
                            voteCentre.vote(j, rangeInfo);
                            if (!this._rangeEqualComparison(rangeInfo, value, parameterConverters, parameterIndex)) continue block8;
                            expressVoting = true;
                            continue block8;
                        }
                        expressVoting = true;
                    }
                }
            }
        }

        private boolean _rangeEqualComparison(RangeInfo rangeInfo, Object value, List<AbstractConverter> parameterConverters, int paramIndex) throws SQLException {
            if (rangeInfo.isRestRange()) {
                return true;
            }
            switch (parameterConverters.get(paramIndex - 1).getColumnType()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 93: {
                    long longValue = (Long)value;
                    long longFloor = rangeInfo.getLongFloor();
                    if (rangeInfo.getMultiValueRange() == 1) {
                        return longFloor <= longValue && longValue < rangeInfo.getLongCeil();
                    }
                    return longFloor == longValue;
                }
                case 3: {
                    BigDecimal bdValue = (BigDecimal)value;
                    BigDecimal bdFloor = rangeInfo.getBdFloor();
                    if (rangeInfo.getMultiValueRange() == 1) {
                        return bdFloor.compareTo(bdValue) <= 0 && bdValue.compareTo(rangeInfo.getBdCeil()) < 0;
                    }
                    return bdFloor.compareTo(bdValue) == 0;
                }
                case -15: 
                case -9: 
                case 12: {
                    String stringValue = (String)value;
                    String stringFloor = rangeInfo.getStringFloor();
                    if (rangeInfo.getMultiValueRange() == 1) {
                        return stringFloor.compareTo(stringValue) <= 0 && stringValue.compareTo(rangeInfo.getStringCeil()) < 0;
                    }
                    return stringFloor.compareTo(stringValue) == 0;
                }
            }
            return false;
        }

        private boolean _rangeLessThanEqualComparison(RangeInfo rangeInfo, Object value, List<AbstractConverter> parameterConverters, int paramIndex) throws SQLException {
            if (rangeInfo.isRestRange()) {
                return true;
            }
            switch (parameterConverters.get(paramIndex - 1).getColumnType()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 93: {
                    return rangeInfo.getLongFloor() <= (Long)value;
                }
                case 3: {
                    return rangeInfo.getBdFloor().compareTo((BigDecimal)value) <= 0;
                }
                case -15: 
                case -9: 
                case 12: {
                    return rangeInfo.getStringFloor().compareTo((String)value) <= 0;
                }
            }
            return false;
        }

        private boolean _rangeLessThanComparison(RangeInfo rangeInfo, Object value, List<AbstractConverter> parameterConverters, int paramIndex) throws SQLException {
            if (rangeInfo.isRestRange()) {
                return true;
            }
            switch (parameterConverters.get(paramIndex - 1).getColumnType()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 93: {
                    return rangeInfo.getLongFloor() < (Long)value;
                }
                case 3: {
                    return rangeInfo.getBdFloor().compareTo((BigDecimal)value) < 0;
                }
                case -15: 
                case -9: 
                case 12: {
                    return rangeInfo.getStringFloor().compareTo((String)value) < 0;
                }
            }
            return false;
        }

        private boolean _rangeGreaterThanEqualComparison(RangeInfo rangeInfo, Object value, List<AbstractConverter> parameterConverters, int paramIndex) throws SQLException {
            if (rangeInfo.isRestRange()) {
                return true;
            }
            switch (parameterConverters.get(paramIndex - 1).getColumnType()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 93: {
                    long longValue = (Long)value;
                    if (rangeInfo.getMultiValueRange() == 1) {
                        return rangeInfo.getLongCeil() > longValue;
                    }
                    return rangeInfo.getLongFloor() >= longValue;
                }
                case 3: {
                    BigDecimal bdValue = (BigDecimal)value;
                    if (rangeInfo.getMultiValueRange() == 1) {
                        return rangeInfo.getBdCeil().compareTo(bdValue) > 0;
                    }
                    return rangeInfo.getBdFloor().compareTo(bdValue) >= 0;
                }
                case -15: 
                case -9: 
                case 12: {
                    String stringValue = (String)value;
                    if (rangeInfo.getMultiValueRange() == 1) {
                        return rangeInfo.getStringCeil().compareTo(stringValue) > 0;
                    }
                    return rangeInfo.getStringFloor().compareTo(stringValue) >= 0;
                }
            }
            return false;
        }

        private boolean _rangeGreaterThanComparison(RangeInfo rangeInfo, Object value, List<AbstractConverter> parameterConverters, int paramIndex) throws SQLException {
            if (rangeInfo.isRestRange()) {
                return true;
            }
            switch (parameterConverters.get(paramIndex - 1).getColumnType()) {
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 93: {
                    long longValue = (Long)value;
                    if (rangeInfo.getMultiValueRange() == 1) {
                        return rangeInfo.getLongCeil() > longValue + 1L;
                    }
                    return rangeInfo.getLongFloor() > longValue;
                }
                case 3: {
                    BigDecimal bdValue = (BigDecimal)value;
                    if (rangeInfo.getMultiValueRange() == 1) {
                        int scale = parameterConverters.get(paramIndex - 1).getScale();
                        BigDecimal minValue = BigDecimal.valueOf(Math.pow(0.1, scale)).setScale(scale, RoundingMode.FLOOR);
                        return rangeInfo.getBdCeil().compareTo(bdValue.add(minValue)) > 0;
                    }
                    return rangeInfo.getBdFloor().compareTo(bdValue) > 0;
                }
                case -15: 
                case -9: 
                case 12: {
                    String stringValue = (String)value;
                    if (rangeInfo.getMultiValueRange() == 1) {
                        return rangeInfo.getStringCeil().compareTo(stringValue) > 0;
                    }
                    return rangeInfo.getStringFloor().compareTo(stringValue) > 0;
                }
            }
            return false;
        }

        private SiteTypeVolumeID _selectSiteTypeVolumeIDFromList(RangeInfo rangeInfo) {
            SiteTypeVolumeIDRotationList rotationList = this._rangeInfoToRotationList.get(rangeInfo);
            return rotationList._next();
        }

        RangePartitionInfo getRangePartitionInfo() {
            return this._rangePartitionInfo;
        }
    }

    private class PartitionInformationHashNode
    extends PartitionInformationTreeNode {
        private final Map<Integer, Integer> _partitionIndexToSubpartitionNodeIndex;
        private final Map<Integer, SiteTypeVolumeIDRotationList> _partitionIndexToRotationlist;
        private final HashPartitionInfo _hashPartitionInfo;

        private PartitionInformationHashNode(Tracer tracer, HashPartitionInfo hashPartitionInfo, PartitionInformationTree hostingTree, PartitionMethod partitionMethod) {
            super(tracer, hostingTree, partitionMethod);
            this._partitionIndexToSubpartitionNodeIndex = new HashMap<Integer, Integer>();
            this._partitionIndexToRotationlist = new HashMap<Integer, SiteTypeVolumeIDRotationList>();
            if (hashPartitionInfo == null) {
                throw new IllegalArgumentException("HashPartitionInfo cannot be null");
            }
            this._hashPartitionInfo = hashPartitionInfo;
            this.tracePartitionInformation();
            int partitionIndex = 0;
            int numberOfTreeNodes = hostingTree._getNumberOfTreeNodes();
            for (List<SiteTypeVolumeID> siteTypeVolumeIDs : this._hashPartitionInfo.getPartitionAssignmentMap().values()) {
                boolean isSubpartition = false;
                for (SiteTypeVolumeID siteTypeVolumeID : siteTypeVolumeIDs) {
                    if (siteTypeVolumeID.isSubpartition()) {
                        if (siteTypeVolumeIDs.size() > 1 || isSubpartition) {
                            throw new IllegalArgumentException("Cannot have aggregate volume IDs for a subpartition");
                        }
                        isSubpartition = true;
                    }
                    if (isSubpartition) {
                        this.getHostingTree()._incrementExpectedNumberOfTreeNodes();
                        this._partitionIndexToSubpartitionNodeIndex.put(partitionIndex, ++numberOfTreeNodes);
                        continue;
                    }
                    this._partitionIndexToRotationlist.put(partitionIndex, new SiteTypeVolumeIDRotationList(siteTypeVolumeIDs, this.getHostingTree().getVolumeIDAffinity()));
                    this._partitionIndexToSubpartitionNodeIndex.put(partitionIndex, null);
                }
                ++partitionIndex;
            }
            this.getHostingTree()._addNewPartitionMethodForParameters(this._hashPartitionInfo.getPartitionParameterInfoList(), partitionMethod);
        }

        @Override
        SiteTypeVolumeID computeSiteTypeVolumeID() throws SQLException {
            SiteTypeVolumeID siteTypeVolumeID;
            this._tracer.printDebugMessage(this.toString() + ": computeSiteTypeVolumeID");
            try {
                int parameterCount = this._hashPartitionInfo.getParameterCount();
                int partitionCount = this._hashPartitionInfo.getPartitionCount();
                List<PartitionParameterInfo> partitionParameterInfoList = this._hashPartitionInfo.getPartitionParameterInfoList();
                List parameterConverters = this.getHostingTree()._parameterConverters;
                List rawInputArgs = this.getHostingTree()._rawInputHashArgs;
                this._validateParameterInformation(parameterCount, partitionCount, parameterConverters, partitionParameterInfoList);
                int partindex = this._computePartitionIndex(parameterCount, partitionCount, partitionParameterInfoList, parameterConverters, rawInputArgs);
                if (this._isSubpartition(partindex)) {
                    Integer subPartitionNodeIndex = this._partitionIndexToSubpartitionNodeIndex.get(partindex);
                    this._tracer.printDebugMessage(this.toString() + "Subpartitioning hash partition " + partindex + " to Partition Tree node " + subPartitionNodeIndex);
                    return this.getHostingTree()._getTreeNode(subPartitionNodeIndex).computeSiteTypeVolumeID();
                }
                siteTypeVolumeID = this._selectSiteTypeVolumeIDFromList(partindex);
            }
            catch (IllegalArgumentException e) {
                siteTypeVolumeID = new SiteTypeVolumeID(SiteType.NONE, -1);
            }
            return siteTypeVolumeID;
        }

        @Override
        SiteTypeVolumeID getFirstPartitionVolumeID() throws IllegalArgumentException {
            if (!PartitionInformationTree.this._isComplete()) {
                throw new IllegalArgumentException("The Partition Tree is not complete");
            }
            List<SiteTypeVolumeID> siteTypeVolumeIDs = this._hashPartitionInfo.getPartitionAssignmentMap().values().iterator().next();
            SiteTypeVolumeID siteTypeVolumeID = siteTypeVolumeIDs.get(0);
            if (siteTypeVolumeID.isSubpartition()) {
                Integer subPartitionNodeIndex = this._partitionIndexToSubpartitionNodeIndex.get(0);
                return this.getHostingTree()._getTreeNode(subPartitionNodeIndex).getFirstPartitionVolumeID();
            }
            return siteTypeVolumeID;
        }

        @Override
        void tracePartitionInformation() {
            if (!this._tracer.getTraceConfiguration().getTraceLevel().get(5) || this._hashPartitionInfo == null) {
                return;
            }
            String lineSeparator = System.getProperty("line.separator");
            String traceString = this.toString() + ": Partitioning at Tree Node[" + this.getHostingTree()._getNumberOfTreeNodes() + "]" + lineSeparator + this._hashPartitionInfo._toString(this.getHostingTree()._getNumberOfTreeNodes());
            this._tracer.printDebugMessage(traceString);
        }

        private boolean _isSubpartition(int partitionIndex) {
            return this._partitionIndexToSubpartitionNodeIndex.containsKey(partitionIndex) && this._partitionIndexToSubpartitionNodeIndex.get(partitionIndex) != null;
        }

        private void _validateParameterInformation(int parameterCount, int partitionCount, List<AbstractConverter> parameterConverters, List<PartitionParameterInfo> partitionParameterInfoList) throws IllegalArgumentException {
            if (parameterCount <= 0 || partitionCount <= 0 || parameterConverters == null || parameterCount > parameterConverters.size() || partitionParameterInfoList == null || partitionParameterInfoList.size() != parameterCount) {
                throw new IllegalArgumentException();
            }
        }

        private int _computePartitionIndex(int parameterCount, int partitionCount, List<PartitionParameterInfo> partitionParameterInfoList, List<AbstractConverter> parameterConverters, List<Object> rawInputArgs) throws SQLException, IllegalArgumentException {
            int partitionIndex = 0;
            int flag = -1;
            for (int i = 0; i < parameterCount; ++i) {
                long hashVal;
                Object value;
                PartitionParameterInfo partitionParameterInfo = partitionParameterInfoList.get(i);
                int parameterIndex = partitionParameterInfo.getParameterIndex();
                if (parameterIndex < 0 || parameterIndex > parameterConverters.size()) {
                    this._tracer.printDebugMessage(this.toString() + "Invalid parameter index: " + parameterIndex);
                    throw new IllegalArgumentException();
                }
                Object rawInputArg = rawInputArgs.get(parameterIndex - 1);
                if (rawInputArg instanceof byte[]) {
                    value = (byte[])rawInputArg;
                    hashVal = Hash.calculateHash(value);
                } else {
                    PartitionParameterFunction partitionParameterFunction;
                    if (rawInputArg == null || rawInputArg == PreparedStatementSapDB.UNINITIALIZED_PARAMETER_VALUE || !(rawInputArg instanceof String)) continue;
                    value = (String)rawInputArg;
                    if (parameterConverters.get(parameterIndex - 1).getColumnType() == 93 && (value = (Object)this._convertTimestampForPartitioning((String)value, partitionParameterFunction = partitionParameterInfo.getPartitionParameterFunction(), true)) == null) {
                        throw new IllegalArgumentException();
                    }
                    hashVal = Hash.calculateHash((String)value);
                }
                flag = 0;
                if ((partitionIndex += (int)(hashVal % (long)partitionCount)) < partitionCount) continue;
                partitionIndex %= partitionCount;
            }
            if (flag == -1) {
                throw new IllegalArgumentException();
            }
            return partitionIndex;
        }

        private SiteTypeVolumeID _selectSiteTypeVolumeIDFromList(int partitionNumber) {
            SiteTypeVolumeIDRotationList rotationList = this._partitionIndexToRotationlist.get(partitionNumber);
            return rotationList._next();
        }

        HashPartitionInfo getHashPartitionInfo() {
            return this._hashPartitionInfo;
        }
    }

    private static abstract class PartitionInformationTreeNode {
        protected final Tracer _tracer;
        protected final PartitionInformationTree _hostingTree;
        private final PartitionMethod _partitionMethod;

        private PartitionInformationTreeNode(Tracer tracer, PartitionInformationTree hostingTree, PartitionMethod partitionMethod) {
            this._tracer = tracer;
            this._hostingTree = hostingTree;
            this._partitionMethod = partitionMethod;
        }

        abstract SiteTypeVolumeID computeSiteTypeVolumeID() throws SQLException;

        abstract SiteTypeVolumeID getFirstPartitionVolumeID() throws IllegalArgumentException;

        abstract void tracePartitionInformation();

        PartitionInformationTree getHostingTree() {
            return this._hostingTree;
        }

        PartitionMethod getPartitionMethod() {
            return this._partitionMethod;
        }

        protected String _convertTimestampForPartitioning(String timestampString, PartitionParameterFunction partitionParameterFunction, boolean needDashes) {
            Timestamp timestamp;
            if (timestampString == null || timestampString.trim().isEmpty() || partitionParameterFunction == null) {
                return null;
            }
            String sep = needDashes ? "-" : "";
            Calendar calendar = (Calendar)CALENDAR.get();
            try {
                timestamp = Timestamp.valueOf(timestampString);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            calendar.setTime(timestamp);
            switch (partitionParameterFunction) {
                case None: {
                    return String.format("%04d%s%02d%s%02d", calendar.get(1), sep, calendar.get(2) + 1, sep, calendar.get(5));
                }
                case Year: {
                    return String.format("%04d", calendar.get(1));
                }
                case Month: {
                    return String.format("%04d%s%02d", calendar.get(1), sep, calendar.get(2) + 1);
                }
            }
            return null;
        }
    }

    private static class SiteTypeVolumeIDRotationList {
        private final List<SiteTypeVolumeID> _siteTypeVolumeIDs;
        private final int _volumeIDAffinity;
        private int _listIndex;
        private int _reuseCount;

        private SiteTypeVolumeIDRotationList(List<SiteTypeVolumeID> siteTypeVolumeIDs, int volumeIDAffinity) {
            this._siteTypeVolumeIDs = siteTypeVolumeIDs;
            this._volumeIDAffinity = volumeIDAffinity;
        }

        private SiteTypeVolumeID _next() {
            ++this._reuseCount;
            int listIndex = this._listIndex;
            if (this._reuseCount == this._volumeIDAffinity) {
                this._listIndex = (this._listIndex + 1) % this._siteTypeVolumeIDs.size();
                this._reuseCount = 0;
            }
            return this._siteTypeVolumeIDs.get(listIndex);
        }
    }
}

