/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.exceptions;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.trace.Tracer;

@ThreadSafe
public class RTEException
extends Exception {
    private final RteReturnCode _rteReturnCode;
    private final int _detailErrorCode;

    public RTEException(Tracer tracer, String message, RteReturnCode rteReturnCode) {
        this(tracer, message, rteReturnCode, rteReturnCode.getCommunicationErrorCode(), null);
    }

    public RTEException(Tracer tracer, String message, RteReturnCode rteReturnCode, int detailErrorCode) {
        this(tracer, message, rteReturnCode, detailErrorCode, null);
    }

    public RTEException(Tracer tracer, String message, RteReturnCode rteReturnCode, Throwable cause) {
        this(tracer, message, rteReturnCode, rteReturnCode.getCommunicationErrorCode(), cause);
    }

    public RTEException(Tracer tracer, String message, RteReturnCode rteReturnCode, int detailErrorCode, Throwable cause) {
        super(message);
        this._rteReturnCode = rteReturnCode;
        this._detailErrorCode = detailErrorCode;
        if (tracer.on()) {
            tracer.printCurrentStackTrace("RTEException: " + (Object)((Object)rteReturnCode) + "(" + rteReturnCode.getValue() + ") " + detailErrorCode + " " + message);
        }
        this.initCause(cause);
    }

    public RteReturnCode getRTEReturnCode() {
        return this._rteReturnCode;
    }

    public int getDetailErrorCode() {
        return this._detailErrorCode;
    }

    public boolean isTimeoutError() {
        return false;
    }

    public boolean isDecompressError() {
        return false;
    }

    public boolean isInvalidPacketError() {
        return false;
    }
}

