/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.util.ByteUtils;
import java.util.UUID;

@Immutable
public final class UUIDUtils {
    private UUIDUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static UUID newInstance(byte[] buffer) {
        return UUIDUtils.newInstance(buffer, 0);
    }

    public static UUID newInstance(byte[] buffer, int offset) {
        long msbits = ByteUtils.getLongBigEndian(buffer, offset);
        long lsbits = ByteUtils.getLongBigEndian(buffer, offset + 8);
        return new UUID(msbits, lsbits);
    }

    public static String toHexString(UUID uuid) {
        return UUIDUtils.toHexString(uuid.toString());
    }

    public static String toHexString(String uuidString) {
        return uuidString.replace("-", "");
    }

    public static byte[] getBytes(UUID uuid) {
        byte[] buf = new byte[16];
        ByteUtils.putLong(uuid.getLeastSignificantBits(), buf, 0);
        ByteUtils.putLong(uuid.getMostSignificantBits(), buf, 8);
        return buf;
    }
}

