/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.green;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.green.model.v20170112.TextScanRequest;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunGreenSDK {
    private static final transient Logger logger = LoggerFactory.getLogger(AliyunGreenSDK.class);
    private static final String REGION_ID = "cn-qingdao";
    private static final String DOMAIN = "green.cn-shanghai.aliyuncs.com";
    private static final String ACCESS_KEY_ID = "LTAIaEOGyV4UnX0G";
    private static final String ACCESS_KEY_SECRET = "L6w7KoLLp1wxhUe195HiSFYjK81ye7";
    private static IAcsClient client = null;
    private static final String UNIFIED_ENCODING = "UTF-8";
    private static final int DEFAULT_CONNECT_TIME_OUT_MILLS = 2000;
    private static final int DEFAULT_READ_TIME_OUT_MILLS = 3000;
    private static final List<String> DEFAULT_SCENES = Arrays.asList("antispam");
    private static final int SUCCESS_CODE = 200;
    private static final String PASS_SUGGESTION = "pass";
    private static final String REVIEW_SUGGESTION = "review";
    private static final String BLOCK_SUGGESTION = "block";
    private static final Map<String, String> invalidLableMapping = new HashMap<String, String>();

    public static boolean block(String suggestion) {
        return StringUtils.equals((CharSequence)suggestion, (CharSequence)REVIEW_SUGGESTION) || StringUtils.equals((CharSequence)suggestion, (CharSequence)BLOCK_SUGGESTION);
    }

    public static JSONArray sendScanTasks(List<String> toBeScanedTextList) {
        IAcsClient client = AliyunGreenSDK.getClient();
        try {
            HttpResponse response = client.doAction((AcsRequest)AliyunGreenSDK.buildScanTaskRequest(toBeScanedTextList));
            JSONArray successScanResults = AliyunGreenSDK.getSuccessScanResultsFromResponse(response);
            if (successScanResults == null) {
                return null;
            }
            JSONArray dealSuggestions = AliyunGreenSDK.parseDealSuggestionsSuccessScanResults(successScanResults);
            return dealSuggestions;
        }
        catch (ClientException e) {
            logger.error("an ClientException occurred when doing action with scan task");
            return null;
        }
    }

    public static JSONObject sendScanTask(String toBeScanedText) {
        IAcsClient client = AliyunGreenSDK.getClient();
        try {
            HttpResponse response = client.doAction((AcsRequest)AliyunGreenSDK.buildScanTaskRequest(toBeScanedText));
            JSONArray successScanResults = AliyunGreenSDK.getSuccessScanResultsFromResponse(response);
            if (successScanResults == null) {
                return null;
            }
            JSONArray dealSuggestions = AliyunGreenSDK.parseDealSuggestionsSuccessScanResults(successScanResults);
            return dealSuggestions.getJSONObject(0);
        }
        catch (ClientException e) {
            logger.error("an ClientException occured when doing action with scan task");
            return null;
        }
    }

    private static IAcsClient getClient() {
        return client;
    }

    private static TextScanRequest buildScanTaskRequest(List<String> toBeScanedTextList) {
        TextScanRequest textScanRequest = new TextScanRequest();
        textScanRequest.setAcceptFormat(FormatType.JSON);
        textScanRequest.setContentType(FormatType.JSON);
        textScanRequest.setMethod(MethodType.POST);
        textScanRequest.setEncoding(UNIFIED_ENCODING);
        textScanRequest.setRegionId(REGION_ID);
        JSONObject data = AliyunGreenSDK.buildScanTaskRequestData(toBeScanedTextList);
        try {
            textScanRequest.setContent(data.toJSONString().getBytes(UNIFIED_ENCODING), UNIFIED_ENCODING, FormatType.JSON);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("an UnsupportedEncodingException occurred when getting bytes from scan request content, the incorrent encoding isUTF-8");
        }
        textScanRequest.setConnectTimeout(Integer.valueOf(2000));
        textScanRequest.setReadTimeout(Integer.valueOf(3000));
        return textScanRequest;
    }

    private static TextScanRequest buildScanTaskRequest(String toBeScanedTextList) {
        return AliyunGreenSDK.buildScanTaskRequest(Arrays.asList(toBeScanedTextList));
    }

    public static JSONArray getSuccessScanResultsFromResponse(HttpResponse textScanResponse) {
        if (!textScanResponse.isSuccess()) {
            int httpStatusCode = textScanResponse.getStatus();
            logger.error("error http status code from text scan response,the http status code is " + httpStatusCode);
            return null;
        }
        String responseContent = null;
        try {
            responseContent = new String(textScanResponse.getContent(), UNIFIED_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("an UnsupportedEncodingException occurred when getting bytes from scan response content, the incorrent encoding isUTF-8");
        }
        JSONObject scrResponse = JSON.parseObject((String)responseContent);
        int errorCode = scrResponse.getInteger("code");
        if (errorCode != 200) {
            String errorMessage = scrResponse.getString("msg");
            logger.error("error code from text scan response,the error code is " + errorCode + ",detail message:" + errorMessage);
            return null;
        }
        JSONArray successScanResults = scrResponse.getJSONArray("data");
        return successScanResults;
    }

    public static JSONArray parseDealSuggestionsSuccessScanResults(JSONArray successScanResults) {
        JSONArray dealSuggestions = new JSONArray();
        for (Object result : successScanResults) {
            JSONObject jsonResult = (JSONObject)result;
            JSONObject dealSuggestion = new JSONObject();
            int code = jsonResult.getInteger("code");
            if (code != 200) {
                dealSuggestion.put("success", (Object)false);
                dealSuggestion.put("suggestion", null);
                dealSuggestion.put("blockLabels", null);
                dealSuggestion.put("reviewLabels", null);
                dealSuggestion.put("tip", null);
                continue;
            }
            JSONArray sceneResults = jsonResult.getJSONArray("results");
            boolean hasBlock = false;
            boolean hasReview = false;
            StringBuffer blockTip = new StringBuffer("\u53d1\u5e03\u5185\u5bb9\u542b\u6709");
            StringBuffer reviewTip = new StringBuffer("\u53d1\u5e03\u5185\u5bb9\u7591\u4f3c\u542b\u6709");
            ArrayList<String> blockLabels = new ArrayList<String>();
            ArrayList<String> reviewLabels = new ArrayList<String>();
            for (Object sceneResult : sceneResults) {
                JSONObject jsonSceneResult = (JSONObject)sceneResult;
                String label = jsonSceneResult.getString("label");
                String suggestion = jsonSceneResult.getString("suggestion");
                if (StringUtils.equals((CharSequence)suggestion, (CharSequence)BLOCK_SUGGESTION)) {
                    blockTip.append(invalidLableMapping.get(label));
                    hasBlock = true;
                    blockLabels.add(label);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)suggestion, (CharSequence)REVIEW_SUGGESTION)) continue;
                reviewTip.append(invalidLableMapping.get(label));
                hasReview = true;
                reviewLabels.add(label);
            }
            dealSuggestion.put("success", (Object)true);
            if (hasBlock) {
                dealSuggestion.put("suggestion", (Object)BLOCK_SUGGESTION);
                dealSuggestion.put("tip", (Object)blockTip);
                dealSuggestion.put("blockLabels", blockLabels);
                dealSuggestions.add((Object)dealSuggestion);
                continue;
            }
            if (hasReview) {
                dealSuggestion.put("suggestion", (Object)REVIEW_SUGGESTION);
                dealSuggestion.put("tip", (Object)reviewTip);
                dealSuggestion.put("reviewLabels", reviewLabels);
                dealSuggestions.add((Object)dealSuggestion);
                continue;
            }
            dealSuggestion.put("suggestion", (Object)PASS_SUGGESTION);
            dealSuggestion.put("tip", (Object)"\u5185\u5bb9\u6b63\u5e38");
            dealSuggestions.add((Object)dealSuggestion);
        }
        return dealSuggestions;
    }

    public static JSONObject buildScanTaskRequestData(String toBeScanedText) {
        JSONObject data = new JSONObject();
        data.put("scenes", DEFAULT_SCENES);
        ArrayList<Map<String, Object>> tasks = new ArrayList<Map<String, Object>>();
        tasks.add(AliyunGreenSDK.buildTextScanTaskJson(toBeScanedText));
        data.put("tasks", tasks);
        return data;
    }

    private static JSONObject buildScanTaskRequestData(List<String> toBeScanedTextList) {
        JSONObject data = new JSONObject();
        data.put("scenes", DEFAULT_SCENES);
        ArrayList<Map<String, Object>> tasks = new ArrayList<Map<String, Object>>();
        for (String toBeScanedText : toBeScanedTextList) {
            tasks.add(AliyunGreenSDK.buildTextScanTaskJson(toBeScanedText));
        }
        data.put("tasks", tasks);
        return data;
    }

    private static Map<String, Object> buildTextScanTaskJson(String toBeScanedText) {
        LinkedHashMap<String, Object> textScanTaskJson = new LinkedHashMap<String, Object>();
        textScanTaskJson.put("dataId", UUID.randomUUID().toString());
        textScanTaskJson.put("content", toBeScanedText);
        return textScanTaskJson;
    }

    private AliyunGreenSDK() {
    }

    public static void main(String[] args) {
        String content = "\u4e60\u8fd1\u5e73\u6e23\u6e23";
        JSONObject dealSuggestion = AliyunGreenSDK.sendScanTask(content);
        System.out.println(JSON.toJSONString((Object)dealSuggestion, (boolean)true));
    }

    static {
        invalidLableMapping.put("spam", "\u5783\u573e");
        invalidLableMapping.put("ad", "\u5e7f\u544a");
        invalidLableMapping.put("politics", "\u653f\u6cbb");
        invalidLableMapping.put("terrorism", "\u66b4\u6050");
        invalidLableMapping.put("abuse", "\u8fb1\u9a82");
        invalidLableMapping.put("porn", "\u8272\u60c5");
        invalidLableMapping.put("contraband", "\u8fdd\u7981");
        DefaultProfile profile = DefaultProfile.getProfile((String)REGION_ID, (String)ACCESS_KEY_ID, (String)ACCESS_KEY_SECRET);
        try {
            DefaultProfile.addEndpoint((String)REGION_ID, (String)REGION_ID, (String)"Green", (String)DOMAIN);
            client = new DefaultAcsClient((IClientProfile)profile);
        }
        catch (ClientException e) {
            logger.error("an ClientException ocurred when initializing AliyunGreenSDK");
            e.printStackTrace();
        }
    }
}

