/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.green;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.sdk.green.BaseSample;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.green.model.v20170112.ImageAsyncScanRequest;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.UUID;

public class ImageAsyncScanRequestSample
extends BaseSample {
    public static void main(String[] args) throws Exception {
        DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)accessKeySecret);
        DefaultProfile.addEndpoint((String)ImageAsyncScanRequestSample.getEndPointName(), (String)regionId, (String)"Green", (String)ImageAsyncScanRequestSample.getDomain());
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        ImageAsyncScanRequest imageAsyncScanRequest = new ImageAsyncScanRequest();
        imageAsyncScanRequest.setAcceptFormat(FormatType.JSON);
        imageAsyncScanRequest.setContentType(FormatType.JSON);
        imageAsyncScanRequest.setMethod(MethodType.POST);
        imageAsyncScanRequest.setEncoding("utf-8");
        imageAsyncScanRequest.setRegionId(regionId);
        ArrayList tasks = new ArrayList();
        LinkedHashMap<String, Object> task1 = new LinkedHashMap<String, Object>();
        task1.put("dataId", UUID.randomUUID().toString());
        task1.put("url", "http://xxxx.jpg");
        task1.put("time", new Date());
        tasks.add(task1);
        JSONObject data = new JSONObject();
        data.put("scenes", Arrays.asList("porn", "ocr", "qrcode", "sface"));
        data.put("tasks", tasks);
        imageAsyncScanRequest.setContent(data.toJSONString().getBytes("UTF-8"), "UTF-8", FormatType.JSON);
        imageAsyncScanRequest.setConnectTimeout(Integer.valueOf(3000));
        imageAsyncScanRequest.setReadTimeout(Integer.valueOf(6000));
        try {
            HttpResponse httpResponse = client.doAction((AcsRequest)imageAsyncScanRequest);
            if (httpResponse.isSuccess()) {
                JSONObject scrResponse = JSON.parseObject((String)new String(httpResponse.getContent(), "UTF-8"));
                System.out.println(JSON.toJSONString((Object)scrResponse, (boolean)true));
                if (200 == scrResponse.getInteger("code")) {
                    JSONArray taskResults = scrResponse.getJSONArray("data");
                    for (Object taskResult : taskResults) {
                        if (200 == ((JSONObject)taskResult).getInteger("code")) {
                            String taskId = ((JSONObject)taskResult).getString("taskId");
                            System.out.println("args = [" + taskId + "]");
                            continue;
                        }
                        System.out.println("task process fail:" + ((JSONObject)taskResult).getInteger("code"));
                    }
                } else {
                    System.out.println("detect not success. code:" + scrResponse.getInteger("code"));
                }
            } else {
                System.out.println("response not success. status:" + httpResponse.getStatus());
            }
        }
        catch (ServerException e) {
            e.printStackTrace();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

