/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.sdk.green;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.sdk.green.BaseSample;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.green.model.v20170112.ImageSyncScanRequest;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.UUID;

public class ImageSyncScanRequestSample
extends BaseSample {
    public static void main(String[] args) throws Exception {
        block9: {
            DefaultProfile profile = DefaultProfile.getProfile((String)regionId, (String)accessKeyId, (String)accessKeySecret);
            DefaultProfile.addEndpoint((String)ImageSyncScanRequestSample.getEndPointName(), (String)regionId, (String)"Green", (String)ImageSyncScanRequestSample.getDomain());
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            ImageSyncScanRequest imageSyncScanRequest = new ImageSyncScanRequest();
            imageSyncScanRequest.setAcceptFormat(FormatType.JSON);
            imageSyncScanRequest.setContentType(FormatType.JSON);
            imageSyncScanRequest.setMethod(MethodType.POST);
            imageSyncScanRequest.setEncoding("utf-8");
            imageSyncScanRequest.setRegionId(regionId);
            ArrayList tasks = new ArrayList();
            LinkedHashMap<String, Object> task = new LinkedHashMap<String, Object>();
            task.put("dataId", UUID.randomUUID().toString());
            task.put("url", "http://xxxx.jpg");
            task.put("time", new Date());
            tasks.add(task);
            JSONObject data = new JSONObject();
            data.put("scenes", Arrays.asList("porn", "ocr", "qrcode", "sface"));
            data.put("tasks", tasks);
            imageSyncScanRequest.setContent(data.toJSONString().getBytes("UTF-8"), "UTF-8", FormatType.JSON);
            imageSyncScanRequest.setConnectTimeout(Integer.valueOf(3000));
            imageSyncScanRequest.setReadTimeout(Integer.valueOf(6000));
            try {
                HttpResponse httpResponse = client.doAction((AcsRequest)imageSyncScanRequest);
                if (httpResponse.isSuccess()) {
                    JSONObject scrResponse = JSON.parseObject((String)new String(httpResponse.getContent(), "UTF-8"));
                    System.out.println(JSON.toJSONString((Object)scrResponse, (boolean)true));
                    if (200 == scrResponse.getInteger("code")) {
                        JSONArray taskResults = scrResponse.getJSONArray("data");
                        for (Object taskResult : taskResults) {
                            if (200 == ((JSONObject)taskResult).getInteger("code")) {
                                JSONArray sceneResults = ((JSONObject)taskResult).getJSONArray("results");
                                for (Object sceneResult : sceneResults) {
                                    String scene = ((JSONObject)sceneResult).getString("scene");
                                    String suggestion = ((JSONObject)sceneResult).getString("suggestion");
                                    System.out.println("args = [" + scene + "]");
                                    System.out.println("args = [" + suggestion + "]");
                                }
                                continue;
                            }
                            System.out.println("task process fail:" + ((JSONObject)taskResult).getInteger("code"));
                        }
                        break block9;
                    }
                    System.out.println("detect not success. code:" + scrResponse.getInteger("code"));
                    break block9;
                }
                System.out.println("response not success. status:" + httpResponse.getStatus());
            }
            catch (ServerException e) {
                e.printStackTrace();
            }
            catch (ClientException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

