/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.advice;

import com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException;
import com.wego168.util.StringUtil;
import com.wego168.web.response.RestResponse;
import com.wego168.web.response.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class Advice {
    private Logger logger = LoggerFactory.getLogger(Advice.class);

    @ExceptionHandler(value={MySQLSyntaxErrorException.class})
    public Object handleMethodArgumentNotValidException(MySQLSyntaxErrorException e) {
        RestResponse rest = new RestResponse();
        String errorMessage = e.getLocalizedMessage();
        this.logger.error(errorMessage);
        if (StringUtil.contains((String)errorMessage, (String)"Table")) {
            rest.setCode(StatusCode.TABLE_NOT_FOUND.code());
            String table = this.getTableFromMySQLSyntaxErrorException(errorMessage);
            String readableMessage = this.parseReadableMessageFromTable(table);
            rest.setMessage(readableMessage);
            rest.setData((Object)("\u7f3a\u5c11\u8868\uff1a" + table));
            return rest;
        }
        if (errorMessage.startsWith("Unknown column")) {
            String column = this.getColumnFromMySQLSyntaxErrorException(errorMessage);
            rest.setCode(StatusCode.COLUMN_NOT_FOUND.code());
            rest.setMessage("\u7cfb\u7edf\u7e41\u5fd9");
            rest.setData((Object)("\u7f3a\u5c11\u5b57\u6bb5\uff1a" + column));
            return rest;
        }
        return StatusCode.BUSY;
    }

    private String getTableFromMySQLSyntaxErrorException(String errorMessage) {
        String table = StringUtil.replace((String)errorMessage, (String)"Table '", (String)"");
        table = StringUtil.replace((String)table, (String)"' doesn't exist", (String)"");
        table = table.split("\\.")[1];
        return table;
    }

    private String getColumnFromMySQLSyntaxErrorException(String errorMessage) {
        String column = StringUtil.replace((String)errorMessage, (String)"Unknown column '", (String)"");
        column = StringUtil.replace((String)column, (String)"' in 'field list'", (String)"");
        return column;
    }

    private String parseReadableMessageFromTable(String table) {
        if (StringUtil.equals((String)table, (String)"base_file_server")) {
            return "\u56fe\u7247\u670d\u52a1\u5668\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        if (StringUtil.equals((String)table, (String)"activity_channel_qrcode")) {
            return "\u6d3b\u52a8\u6e20\u9053\u4e8c\u7ef4\u7801\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        if (StringUtil.in((String)table, (String[])new String[]{"distributer_become_condition", "distributer_become_condition_config"})) {
            return "\u9500\u552e\u5458\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        if (StringUtil.in((String)table, (String[])new String[]{"distributer_regist_field", "distributer_regist_field_data"})) {
            return "\u9500\u552e\u5458\u6ce8\u518c\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        if (StringUtil.in((String)table, (String[])new String[]{"distribute_open_id_chain", "distribute_open_id_link"})) {
            return "\u9500\u552e\u5458\u5173\u7cfb\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        if (StringUtil.equals((String)table, (String)"distributer_commission_config")) {
            return "\u9500\u552e\u5458\u4f63\u91d1\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        if (StringUtil.equals((String)table, (String)"distributer_qrcode")) {
            return "\u9500\u552e\u5458\u6d77\u62a5\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        if (StringUtil.in((String)table, (String[])new String[]{"personality_label", "personality_label_template"})) {
            return "\u4e2a\u6027\u6807\u7b7e\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        if (StringUtil.in((String)table, (String[])new String[]{"points", "points_flow", "points_flow_deduct_record"})) {
            return "\u79ef\u5206\u914d\u7f6e\u672a\u5f00\u542f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458";
        }
        return "\u914d\u7f6e\u672a\u5f00\u542f";
    }
}

