/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.advice;

import com.wego168.base.util.TimeZoneUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeUtil {
    public static final String DEFAULT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE = "yyyy-MM-dd";
    public static final String TIME = "HH:mm:ss";
    public static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");

    public static String formatDateTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT);
        return format.format(date);
    }

    public static String formatDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(DATE);
        return format.format(date);
    }

    public static String formatTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat(TIME);
        return format.format(date);
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(date);
    }

    public static Date parseDateTime(String text) {
        SimpleDateFormat format = new SimpleDateFormat(DEFAULT);
        try {
            Date date = format.parse(text);
            return date;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseDate(String text) {
        SimpleDateFormat format = new SimpleDateFormat(DATE);
        try {
            Date date = format.parse(text);
            return date;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseTime(String text) {
        SimpleDateFormat format = new SimpleDateFormat(TIME);
        try {
            Date date = format.parse(text);
            return date;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parse(String text, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            Date date = format.parse(text);
            return date;
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getDateTimeAdd(int calendar, int amount, String strDate) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat(DATE);
        Date date = format.parse(strDate);
        return DateTimeUtil.getDateTimeAdd(calendar, amount, date);
    }

    public static Date getDateTimeAdd(int calendar, int amount, Date date) {
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        now.add(calendar, amount);
        return now.getTime();
    }

    public static String convertFormat(Date date) {
        return DateTimeUtil.convertFormatWithTimeZone(date, null);
    }

    public static String convertFormatWithTimeZone(Date date, TimeZone timeZone) {
        try {
            Calendar calendar1 = Calendar.getInstance();
            calendar1.setTime(date);
            Calendar calendar2 = Calendar.getInstance();
            Date now = TimeZoneUtil.getDateWithTimeZone(new Date(), timeZone);
            int year1 = calendar1.get(1);
            int month1 = calendar1.get(2) + 1;
            int day1 = calendar1.get(5);
            SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
            String time = timeFormat.format(date);
            int year2 = calendar2.get(1);
            Date yesterday = DateTimeUtil.getDateTimeAdd(5, -1, now);
            Date beforeYesterday = DateTimeUtil.getDateTimeAdd(5, -2, now);
            Date tomarrow = DateTimeUtil.getDateTimeAdd(5, 1, now);
            Date afterTomarrow = DateTimeUtil.getDateTimeAdd(5, 2, now);
            SimpleDateFormat format = new SimpleDateFormat(DATE);
            String today = format.format(now);
            String dateStr = format.format(date);
            if (today.equals(dateStr)) {
                return "\u4eca\u5929  " + time;
            }
            if (format.format(yesterday).equals(dateStr)) {
                return "\u6628\u5929  " + time;
            }
            if (format.format(beforeYesterday).equals(dateStr)) {
                return "\u524d\u5929  " + time;
            }
            if (format.format(tomarrow).equals(dateStr)) {
                return "\u660e\u5929  " + time;
            }
            if (format.format(afterTomarrow).equals(dateStr)) {
                return "\u540e\u5929  " + time;
            }
            if (dateStr.compareTo(today) > 0 && DateTimeUtil.getDateTimeAdd(5, 8, today).after(format.parse(dateStr))) {
                return DateTimeUtil.getWeekDayByDate(calendar1, calendar2) + " " + time;
            }
            if (year1 == year2) {
                return month1 + "\u6708" + day1 + "\u65e5  " + time;
            }
            return year1 + "\u5e74" + month1 + "\u6708" + day1 + "\u65e5";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getWeekDayByDate(Calendar calendar1, Calendar calendar2) {
        calendar1.setFirstDayOfWeek(2);
        calendar2.setFirstDayOfWeek(2);
        int currentWeek = calendar2.get(3);
        int paramWeek = calendar1.get(3);
        String weekDay = DateTimeUtil.getWeekDayByDate(calendar1);
        if (currentWeek != paramWeek) {
            return "\u4e0b" + weekDay;
        }
        return "\u672c" + weekDay;
    }

    public static String getWeekDayByDate(Calendar calendar) {
        int dayForWeek = calendar.get(7);
        if (dayForWeek == 1) {
            return "\u5468\u65e5";
        }
        if (dayForWeek == 2) {
            return "\u5468\u4e00";
        }
        if (dayForWeek == 3) {
            return "\u5468\u4e8c";
        }
        if (dayForWeek == 4) {
            return "\u5468\u4e09";
        }
        if (dayForWeek == 5) {
            return "\u5468\u56db";
        }
        if (dayForWeek == 6) {
            return "\u5468\u4e94";
        }
        if (dayForWeek == 7) {
            return "\u5468\u516d";
        }
        return null;
    }

    public static int differentDaysByMillisecond(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return Math.abs(days);
    }

    public static String getWeek(Date date, String separator) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String week = "";
        calendar.setFirstDayOfWeek(2);
        int weekNum = calendar.get(3);
        int year = calendar.get(1);
        week = weekNum < 10 ? year + separator + "0" + weekNum : year + separator + weekNum;
        return week;
    }

    public static String getMonth(Date date, String separator) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String month = "";
        int monthNum = calendar.get(2) + 1;
        int year = calendar.get(1);
        month = monthNum < 10 ? year + separator + "0" + monthNum : year + separator + monthNum;
        return month;
    }

    public static Date calcAddDay(Integer length, Long time) {
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTimeInMillis(date.getTime() + time);
        calendar.add(6, length);
        return calendar.getTime();
    }

    public static Date calcCalendarYear(Date time) {
        Calendar calendar = Calendar.getInstance();
        if (time != null) {
            calendar.setTimeInMillis(time.getTime());
            calendar.add(1, 1);
        }
        calendar.set(calendar.get(1), 11, 31, 23, 59, 59);
        return calendar.getTime();
    }

    public static void main(String[] args) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(date.getTime());
        System.out.println(date);
        System.out.println(calendar.getTime());
    }

    public static Date calcPostponeYear(Integer length, Long time) {
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTimeInMillis(date.getTime() + time);
        calendar.add(1, length);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        return calendar.getTime();
    }
}

