/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.advice;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.DeleteObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.region.Region;
import com.wego168.base.advice.FileSpiltUtil;
import com.wego168.base.domain.FileServer;
import com.wego168.domain.CosAccess;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUploadUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(File targetFile, String randonFileName, String imageType, CosAccess access) {
        COSClient cosClient = null;
        try {
            String tencentCloudCosAppId = access.getAppId();
            String secretId = access.getSecretId();
            String secretKey = access.getSecretKey();
            BasicCOSCredentials cred = new BasicCOSCredentials(tencentCloudCosAppId, secretId, secretKey);
            ClientConfig clientConfig = new ClientConfig(new Region(access.getArea()));
            cosClient = new COSClient((COSCredentials)cred, clientConfig);
            String bucketName = access.getBucket();
            String path = "/attachments/%s/%s";
            String formattedPath = String.format(path, imageType, randonFileName);
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, formattedPath, targetFile);
            cosClient.putObject(putObjectRequest);
            String string = formattedPath;
            return string;
        }
        finally {
            if (cosClient != null) {
                cosClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload(InputStream inputStream, String randonFileName, String imageType, CosAccess access) {
        COSClient cosClient = null;
        String path = "/attachments/%s/%s";
        String formattedPath = String.format(path, imageType, randonFileName);
        try {
            String tencentCloudCosAppId = access.getAppId();
            String secretId = access.getSecretId();
            String secretKey = access.getSecretKey();
            BasicCOSCredentials cred = new BasicCOSCredentials(tencentCloudCosAppId, secretId, secretKey);
            String area = access.getArea();
            ClientConfig clientConfig = new ClientConfig(new Region(area));
            cosClient = new COSClient((COSCredentials)cred, clientConfig);
            String bucketName = access.getBucket();
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, formattedPath, inputStream, objectMetadata);
            cosClient.putObject(putObjectRequest);
            String string = formattedPath;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = formattedPath;
            return string;
        }
        finally {
            if (cosClient != null) {
                cosClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadPart(File file, String dir, String fileName, FileServer server) {
        FileUploadUtil.checkCosDir(dir);
        COSClient cosClient = null;
        String path = "/%s/%s";
        String formattedPath = String.format(path, dir, fileName);
        List<String> files = FileSpiltUtil.splitFile(file);
        String tencentCloudCosAppId = server.getHostAppId();
        String secretId = server.getUsername();
        String secretKey = server.getPassword();
        BasicCOSCredentials cred = new BasicCOSCredentials(tencentCloudCosAppId, secretId, secretKey);
        ClientConfig clientConfig = new ClientConfig(new Region(server.getArea()));
        cosClient = new COSClient((COSCredentials)cred, clientConfig);
        String bucketName = server.getBucket();
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest(bucketName, formattedPath);
        InitiateMultipartUploadResult initiateMultipartUploadResult = cosClient.initiateMultipartUpload(initiateMultipartUploadRequest);
        String uploadId = initiateMultipartUploadResult.getUploadId();
        for (int i = 0; i < files.size(); ++i) {
            File uploadFile = new File(files.get(i));
            if (uploadFile.length() == 0L) continue;
            try (FileInputStream inputStream = new FileInputStream(uploadFile);){
                UploadPartRequest uploadRequest = new UploadPartRequest().withBucketName(bucketName).withUploadId(uploadId).withKey(formattedPath).withPartNumber(i + 1).withInputStream((InputStream)inputStream).withPartSize((long)((InputStream)inputStream).available());
                UploadPartResult uploadPartResult = cosClient.uploadPart(uploadRequest);
                String eTag = uploadPartResult.getETag();
                partETags.add(new PartETag(i + 1, eTag));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error("\u5206\u5757\u4e0a\u4f20\u51fa\u9519-->", (Throwable)e);
                continue;
            }
            finally {
                cosClient.shutdown();
            }
        }
        try {
            System.out.println(partETags);
            CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(bucketName, formattedPath, uploadId, partETags);
            CompleteMultipartUploadResult result = cosClient.completeMultipartUpload(compRequest);
            log.error("cos path" + result);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5b8c\u6210\u5206\u5757\u4e0a\u4f20\u51fa\u9519-->", (Throwable)e);
        }
        finally {
            cosClient.shutdown();
            System.gc();
            if (files.size() > 0) {
                File delete = new File(files.get(0));
                try {
                    FileUtils.deleteDirectory((File)delete.getParentFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return formattedPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload2Cos(InputStream inputStream, String dir, String fileName, FileServer server) {
        FileUploadUtil.checkCosDir(dir);
        COSClient cosClient = null;
        String path = "/%s/%s";
        String formattedPath = String.format(path, dir, fileName);
        if (StringUtil.isBlank((String)dir)) {
            formattedPath = fileName;
        }
        try {
            String tencentCloudCosAppId = server.getHostAppId();
            String secretId = server.getUsername();
            String secretKey = server.getPassword();
            BasicCOSCredentials cred = new BasicCOSCredentials(tencentCloudCosAppId, secretId, secretKey);
            ClientConfig clientConfig = new ClientConfig(new Region(server.getArea()));
            cosClient = new COSClient((COSCredentials)cred, clientConfig);
            String bucketName = server.getBucket();
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, formattedPath, inputStream, objectMetadata);
            cosClient.putObject(putObjectRequest);
            String string = formattedPath;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = formattedPath;
            return string;
        }
        finally {
            if (cosClient != null) {
                cosClient.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String upload2CosWithMonth(InputStream inputStream, String dir, String fileName, FileServer server) {
        String month = new SimpleDateFormat("yyyy-MM").format(new Date());
        String path = "/" + dir + "/" + month + "/" + fileName;
        FileUploadUtil.checkCosDir(path);
        COSClient cosClient = null;
        try {
            String tencentCloudCosAppId = server.getHostAppId();
            String secretId = server.getUsername();
            String secretKey = server.getPassword();
            BasicCOSCredentials cred = new BasicCOSCredentials(tencentCloudCosAppId, secretId, secretKey);
            ClientConfig clientConfig = new ClientConfig(new Region(server.getArea()));
            cosClient = new COSClient((COSCredentials)cred, clientConfig);
            String bucketName = server.getBucket();
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, path, inputStream, objectMetadata);
            cosClient.putObject(putObjectRequest);
            String string = path;
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = path;
            return string;
        }
        finally {
            if (cosClient != null) {
                cosClient.shutdown();
            }
        }
    }

    public static void main(String[] args) {
        File file = new File("E:/lombok.jar");
        FileServer server = new FileServer();
        server.setArea("ap-guangzhou");
        server.setBucket("bill-1258204542");
        server.setHostAppId("1258204542");
        server.setUsername("AKIDAFKDvSMy63pFTXaK4f8RJ0Ws45vaHGG5");
        server.setPassword("mqkT2Qo13vIUWN4Zu31jGdpqfJm441qU");
        System.out.println(FileUploadUtil.upload2Cos(file, "", "lombok.jar", server));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String upload2Cos(File file, String dir, String fileName, FileServer server) {
        FileUploadUtil.checkCosDir(dir);
        COSClient cosClient = null;
        String path = "/%s/%s";
        String formattedPath = String.format(path, dir, fileName);
        if (StringUtil.isBlank((String)dir)) {
            formattedPath = fileName;
        }
        try {
            String string;
            Object object;
            FileInputStream inputStream;
            block19: {
                block20: {
                    inputStream = new FileInputStream(file);
                    object = null;
                    String tencentCloudCosAppId = server.getHostAppId();
                    String secretId = server.getUsername();
                    String secretKey = server.getPassword();
                    BasicCOSCredentials cred = new BasicCOSCredentials(tencentCloudCosAppId, secretId, secretKey);
                    ClientConfig clientConfig = new ClientConfig(new Region(server.getArea()));
                    cosClient = new COSClient((COSCredentials)cred, clientConfig);
                    String bucketName = server.getBucket();
                    ObjectMetadata objectMetadata = new ObjectMetadata();
                    objectMetadata.setContentLength((long)((InputStream)inputStream).available());
                    PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, formattedPath, (InputStream)inputStream, objectMetadata);
                    cosClient.putObject(putObjectRequest);
                    string = formattedPath;
                    if (inputStream == null) break block19;
                    if (object == null) break block20;
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block19;
                }
                ((InputStream)inputStream).close();
            }
            return string;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (inputStream != null) {
                            if (object != null) {
                                try {
                                    ((InputStream)inputStream).close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                ((InputStream)inputStream).close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    log.error("\u4e0a\u4f20\u53d1\u751f\u9519\u8bef", (Throwable)e);
                    object = formattedPath;
                    return object;
                }
            }
        }
        finally {
            if (cosClient != null) {
                cosClient.shutdown();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static String upload2Cos(BufferedImage bufferedImage, String dir, String fileName, FileServer server) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteOnCos(String url, FileServer server) {
        COSClient cosClient = null;
        try {
            String tencentCloudCosAppId = server.getHostAppId();
            String secretId = server.getUsername();
            String secretKey = server.getPassword();
            BasicCOSCredentials cred = new BasicCOSCredentials(tencentCloudCosAppId, secretId, secretKey);
            ClientConfig clientConfig = new ClientConfig(new Region(server.getArea()));
            cosClient = new COSClient((COSCredentials)cred, clientConfig);
            String bucketName = server.getBucket();
            DeleteObjectRequest deleteObjectRequest = new DeleteObjectRequest(bucketName, url);
            cosClient.deleteObject(deleteObjectRequest);
        }
        finally {
            if (cosClient != null) {
                cosClient.shutdown();
            }
        }
    }

    private static void checkCosDir(String dir) {
        if (StringUtil.contains((String)dir, (String)"/")) {
            String[] dirUnits;
            for (String dirUnit : dirUnits = dir.split("/")) {
                Checker.checkLength((String)dirUnit, (String)"\u76ee\u5f55", (int)255);
            }
        } else {
            Checker.checkLength((String)dir, (String)"\u76ee\u5f55", (int)255);
        }
    }
}

