/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Agreement;
import com.wego168.base.domain.AgreementGroup;
import com.wego168.base.domain.Content;
import com.wego168.base.service.AgreementGroupService;
import com.wego168.base.service.AgreementService;
import com.wego168.base.service.ContentService;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdminAgreementController
extends SimpleController {
    @Autowired
    private ContentService contentService;
    @Autowired
    private AgreementService agreementService;
    @Autowired
    private AgreementGroupService agreementGroupService;

    @PostMapping(value={"/api/admin/v1/agreement/insert"})
    public RestResponse insert(String title, String code, String content, Integer sortNumber) {
        try {
            this.checkParameter(title, code, content);
        }
        catch (WegoException e) {
            return RestResponse.error((int)e.getCode(), (String)e.getMessage(), null);
        }
        sortNumber = sortNumber == null ? 0 : sortNumber;
        String appId = this.getAppId();
        Agreement agreementGtDb = this.agreementService.create(title, content, code, sortNumber, appId);
        this.agreementService.insertAgreement(agreementGtDb);
        return RestResponse.success((Object)((Object)agreementGtDb));
    }

    @PostMapping(value={"/api/admin/v1/agreement/delete"})
    public RestResponse delete(String id) {
        try {
            Checker.checkBlank((String)id, (String)"id");
        }
        catch (WegoException e) {
            return RestResponse.error((int)e.getCode(), (String)e.getMessage(), null);
        }
        Agreement agreementDb = (Agreement)((Object)this.agreementService.selectById(id));
        if (agreementDb == null) {
            return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        this.agreementService.deleteAgreementAndContent(agreementDb);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/agreement/update"})
    public RestResponse update(String title, String code, String content, Integer sortNumber, String id) {
        try {
            this.checkParameter(title, code, content);
            Checker.checkBlank((String)id, (String)"id");
        }
        catch (WegoException e) {
            return RestResponse.error((int)e.getCode(), (String)e.getMessage(), null);
        }
        Agreement agreementDb = (Agreement)((Object)this.agreementService.selectById(id));
        if (agreementDb == null) {
            return RestResponse.error((String)"\u8be5\u534f\u8bae\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        sortNumber = sortNumber == null ? 0 : sortNumber;
        agreementDb.setTitle(title);
        agreementDb.setCode(code);
        agreementDb.setContent(content);
        agreementDb.setSortNumber(sortNumber);
        agreementDb.setUpdateTime(new Date());
        Agreement agreementGtDb = agreementDb;
        this.agreementService.updateAgreementAndContent(agreementGtDb);
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/agreement/page"})
    public RestResponse selectPage(String code, HttpServletRequest request) {
        String appId = this.getAppId();
        Page page = this.buildPage(request);
        List<Agreement> list = this.agreementService.selectAdminPage(code, appId, page);
        this.assembleAgreementGroup(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/agreement/get"})
    public RestResponse get(String id) {
        try {
            Checker.checkBlank((String)id, (String)"id");
        }
        catch (WegoException e) {
            return RestResponse.error((int)e.getCode(), (String)e.getMessage(), null);
        }
        String appId = this.getAppId();
        Agreement agreementDb = this.agreementService.selectById(id, appId);
        if (agreementDb == null) {
            return RestResponse.error((String)"\u8be5\u534f\u8bae\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        Content content = (Content)this.contentService.selectById(agreementDb.getContentId());
        agreementDb.setContent(content.getContent());
        String code = agreementDb.getCode();
        AgreementGroup agreementGroup = this.agreementGroupService.selectByCode(code);
        if (agreementGroup != null) {
            agreementDb.setAgreementGroup(agreementGroup.getName());
        } else {
            agreementDb.setAgreementGroup("\u672a\u77e5\u534f\u8bae");
        }
        Agreement agreementGtDb = agreementDb;
        return RestResponse.success((Object)((Object)agreementGtDb));
    }

    private void checkParameter(String title, String code, String content) {
        Checker.checkBlankAndLength((String)title, (String)"\u6807\u9898", (int)64);
        Checker.checkBlank((String)code, (String)"\u534f\u8bae\u7ec4");
        Checker.checkBlank((String)content, (String)"\u534f\u8bae\u5185\u5bb9");
    }

    private void assembleAgreementGroup(List<Agreement> list) {
        block5: {
            if (list == null || list.size() <= 0) break block5;
            List<AgreementGroup> groupList = this.agreementGroupService.selectAll();
            if (groupList != null && groupList.size() > 0) {
                for (AgreementGroup agreementGroup : groupList) {
                    for (Agreement agreement : list) {
                        if (!StringUtil.equals((String)agreement.getCode(), (String)agreementGroup.getCode())) continue;
                        agreement.setAgreementGroup(agreementGroup.getName());
                    }
                }
            } else {
                for (Agreement agreement : list) {
                    agreement.setAgreementGroup("\u672a\u77e5\u534f\u8bae");
                }
            }
        }
    }
}

