/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Area;
import com.wego168.base.service.AreaService;
import com.wego168.service.CrudService;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/v1/area"})
public class AdminAreaController
extends CrudController<Area> {
    @Autowired
    private AreaService areaService;

    public CrudService<Area> getService() {
        return this.areaService;
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5355\u4e2a\u533a\u57df")
    @GetMapping(value={"/get"})
    public RestResponse get(String id) {
        Area area = (Area)((Object)this.getService().selectById((Object)id));
        area = this.areaService.qyeryAndSetHasChild(area);
        return RestResponse.success((Object)((Object)area));
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u533a\u57df\u5217\u8868")
    @GetMapping(value={"/list"})
    public RestResponse list(HttpServletRequest request) {
        return super.list(request);
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/listByType"})
    public RestResponse listByType(Integer type, HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.eq("type", (Object)type);
        List<Area> list = this.areaService.selectPage(page);
        list = this.areaService.qyeryAndSetHasChildByList(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @ApiOperation(value="\u6839\u636eparentId\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/listByParentId"})
    public RestResponse listByParentId(String parentId, HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.eq("parentId", (Object)parentId);
        List<Area> list = this.areaService.selectPage(page);
        list = this.areaService.qyeryAndSetHasChildByList(list);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u533a\u57df")
    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request) {
        return super.page(request);
    }

    @ApiOperation(value="\u6dfb\u52a0\u533a\u57df")
    @PostMapping(value={"/insert"})
    public RestResponse insert(@Valid Area vo) {
        return super.insert((Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u533a\u57df")
    @PostMapping(value={"/insertList"})
    public RestResponse insertList(@Valid @RequestBody Area vo) {
        this.areaService.insertAreaList(vo);
        return RestResponse.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @ApiOperation(value="\u66f4\u65b0\u533a\u57df")
    @PostMapping(value={"/update"})
    public RestResponse update(@Valid Area vo) {
        vo.setUpdateTime(new Date());
        this.areaService.updateSelective((Object)vo);
        return RestResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u533a\u57df")
    @PostMapping(value={"/delete"})
    public RestResponse delete(String id) {
        int row = this.areaService.updateDelete(id);
        return this.responseByRows(row);
    }
}

