/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.alibaba.fastjson.JSONObject;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.advice.FileUploadUtil;
import com.wego168.base.domain.Attachment;
import com.wego168.base.domain.Category;
import com.wego168.base.domain.FileServer;
import com.wego168.base.domain.Ueditor;
import com.wego168.base.model.response.FileUploadResponse;
import com.wego168.base.service.AttachmentService;
import com.wego168.base.service.CategoryService;
import com.wego168.base.service.FileServerService;
import com.wego168.base.service.StorageDecider;
import com.wego168.base.service.UeditorService;
import com.wego168.domain.CosAccess;
import com.wego168.exception.WegoException;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.util.Checker;
import com.wego168.util.EnvironmentUtil;
import com.wego168.util.IntegerUtil;
import com.wego168.util.SequenceUtil;
import com.wego168.util.Shift;
import com.wego168.util.SimpleJackson;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.GuidGenerator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Validated
@RestController
public class AdminAttachmentController
extends SimpleController {
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private AuthenticationUser authenticationUser;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private UeditorService ueditorService;
    @Autowired
    private FileServerService fileServerService;
    @Autowired
    private Environment env;
    @Autowired
    private StorageDecider storageDecider;
    private final Logger logger = LoggerFactory.getLogger(AdminAttachmentController.class);

    @PostMapping(value={"/api/v1/attachments/images/tencent_cloud"})
    public RestResponse uploadImageToTencentCloud(String imageType, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="file") MultipartFile file) throws IOException {
        if (file.getSize() == 0L) {
            return RestResponse.error((String)"\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff1a\u6587\u4ef6\u5927\u5c0f\u4e3a0");
        }
        CosAccess access = EnvironmentUtil.createCosAccess((Environment)this.env);
        if (access == null) {
            return RestResponse.error((String)"cos\u672a\u6b63\u786e\u914d\u7f6e\uff0c\u65e0\u6cd5\u4e0a\u4f20\u56fe\u7247\uff0c\u8bf7\u8054\u7cfb\u7ef4\u62a4\u4eba\u5458\u6216\u5ba2\u670d");
        }
        try {
            String originalFileName = file.getOriginalFilename();
            int index = originalFileName.lastIndexOf(".");
            String subfix = originalFileName.substring(index);
            String randonFileName = GuidGenerator.generate() + subfix;
            String formattedPath = FileUploadUtil.upload(file.getInputStream(), randonFileName, imageType, access);
            long fileSize = file.getSize();
            this.simpleRedisTemplate.set(formattedPath, (Object)fileSize, 600L);
            HashMap<String, String> json = new HashMap<String, String>();
            json.put("imageUrl", formattedPath);
            System.out.println("json -->>>>>" + SimpleJackson.toJson(json));
            return RestResponse.success(json);
        }
        catch (Exception e) {
            this.logger.error("error", (Throwable)e);
            return RestResponse.error((String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u4e0a\u4f20\u4e2d\u53d1\u751f\u4e86\u4e00\u4e2a\u9519\u8bef");
        }
    }

    @PostMapping(value={"/api/admin/v1.1/upload-file"})
    public RestResponse uploadFileToTencentCloud(@NotBlankAndLength(min=1, message="\u6587\u4ef6\u7c7b\u578b\u975e\u6cd5") String fileType, @RequestParam(name="file", required=false) MultipartFile file) throws IOException {
        try {
            Checker.checkCondition((file == null || file.getSize() == 0L ? 1 : 0) != 0, (String)"\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            FileServer server = this.fileServerService.ensure();
            Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u6587\u4ef6\u670d\u52a1\u5668\u672a\u914d\u7f6e");
            String originalFileName = file.getOriginalFilename();
            int index = originalFileName.lastIndexOf(".");
            String subfix = originalFileName.substring(index);
            String randonFileName = SequenceUtil.createUuid() + subfix;
            String formattedPath = FileUploadUtil.upload2CosWithMonth(file.getInputStream(), fileType, randonFileName, server);
            HashMap<String, String> json = new HashMap<String, String>();
            json.put("url", formattedPath);
            json.put("host", server.getHost());
            return RestResponse.success(json);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1.2/upload-file"})
    public RestResponse uploadFileToTencentCloud(@RequestParam(name="file", required=false) MultipartFile file) throws IOException {
        try {
            Checker.checkCondition((file == null || file.getSize() == 0L ? 1 : 0) != 0, (String)"\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            FileServer server = this.fileServerService.ensure();
            Checker.checkCondition((server == null ? 1 : 0) != 0, (String)"\u4e0a\u4f20\u5931\u8d25\uff1a\u6587\u4ef6\u670d\u52a1\u5668\u672a\u914d\u7f6e");
            String originalFileName = file.getOriginalFilename();
            String formattedPath = FileUploadUtil.upload2Cos(file.getInputStream(), "", originalFileName, server);
            HashMap<String, String> json = new HashMap<String, String>();
            json.put("url", formattedPath);
            json.put("host", server.getHost());
            return RestResponse.success(json);
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"/api/admin/v1.3/upload-file"})
    public RestResponse uppload(String path, @RequestParam(name="file", required=false) MultipartFile file) throws IOException {
        Checker.checkCondition((file == null || file.getSize() == 0L ? 1 : 0) != 0, (String)"\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        try (InputStream in = file.getInputStream();){
            String originalFileName = file.getOriginalFilename();
            int index = originalFileName.lastIndexOf(".");
            String subfix = originalFileName.substring(index);
            String randonFileName = SequenceUtil.createUuid() + subfix;
            String filePathAndName = path + "/" + randonFileName;
            FileUploadResponse response = this.storageDecider.decide().simplePut(filePathAndName, in);
            RestResponse restResponse = RestResponse.success((Object)response);
            return restResponse;
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/attachment/insert"})
    public RestResponse insertAttachment(String name, String url, String href, String categoryId, Integer seqNum, String note) {
        this.checkInsertParameter(name, url, href, categoryId, seqNum, note);
        Category category = (Category)this.categoryService.selectById(categoryId);
        if (category == null) {
            return RestResponse.error((String)"\u8be5\u5206\u7c7b\u4e0d\u5b58\u5728");
        }
        String appId = this.authenticationUser.getAppId();
        Long fileSize = (Long)this.simpleRedisTemplate.get(url, Long.class);
        this.logger.error("\u9644\u4ef6\u5927\u5c0f\uff1a" + fileSize);
        fileSize = fileSize == null ? 0L : fileSize;
        Attachment attachment = AttachmentService.create(appId, categoryId, name, href, url, note, seqNum, fileSize);
        this.attachmentService.insert((Object)attachment);
        return RestResponse.success((Object)((Object)attachment));
    }

    @PostMapping(value={"/api/admin/v1/attachment/delete"})
    public RestResponse deleteAttachment(String id) {
        Checker.checkBlank((String)id, (String)"id");
        this.attachmentService.deleteById(id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/attachment/update"})
    public RestResponse updateAttachment(String name, String url, String href, Integer seqNum, String note, String id) {
        this.checkUpdateParameter(name, url, href, seqNum, note, id);
        Long fileSize = (Long)this.simpleRedisTemplate.get(url, Long.class);
        this.attachmentService.update(name, url, href, seqNum, note, fileSize, id);
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/attachment/page"})
    public RestResponse listAttachment(String name, String categoryId, HttpServletRequest request) {
        Category category;
        Page page = this.buildPage(request);
        String appId = this.authenticationUser.getAppId();
        page.eq("appId", (Object)appId);
        if (StringUtil.isNotBlank((String)name)) {
            page.eq("name", (Object)name);
        }
        page.orderBy("seqNum asc");
        if (StringUtil.isNotBlank((String)categoryId) && (category = (Category)this.categoryService.selectById(categoryId)) != null) {
            page.eq("categoryId", (Object)category.getId());
        }
        List list = this.attachmentService.selectPage(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/attachment/get"})
    public RestResponse getAttachment(String id) {
        Checker.checkBlank((String)id, (String)"id");
        Attachment attachment = (Attachment)((Object)this.attachmentService.selectById(id));
        return RestResponse.success((Object)((Object)attachment));
    }

    private void checkInsertParameter(String name, String url, String href, String categoryId, Integer seqNum, String note) {
        Checker.checkBlank((String)name, (String)"\u540d\u79f0");
        Checker.checkBlank((String)url, (String)"\u8def\u5f84");
        Checker.checkBlank((String)categoryId, (String)"\u5206\u7c7b");
        Checker.checkNull((Object)seqNum, (String)"\u5e8f\u53f7");
    }

    private void checkUpdateParameter(String name, String url, String href, Integer seqNum, String note, String id) {
        Checker.checkBlank((String)name, (String)"\u540d\u79f0");
        Checker.checkBlank((String)url, (String)"\u8def\u5f84");
        Checker.checkBlank((String)id, (String)"id");
        Checker.checkNull((Object)seqNum, (String)"\u5e8f\u53f7");
    }

    public JSONObject ueditorUploadImage(@RequestParam(value="file") MultipartFile file, String imageType) {
        return this.actionUploadImage(file, imageType);
    }

    @RequestMapping(value={"/api/v1/attachments/images/ueditor"}, method={RequestMethod.POST, RequestMethod.GET})
    public JSONObject ueditorAction(String action, @RequestParam(name="file", required=false) MultipartFile file, String imageType, @RequestParam(value="source[]", required=false) String[] source) {
        if (StringUtil.isBlank((String)imageType)) {
            imageType = "uploadImage";
        }
        Shift.throwsIfBlank((String)action, (String)"action\u4e0d\u53ef\u4e3a\u7a7a");
        if (StringUtil.equals((String)"config", (String)action)) {
            return this.actionConfig();
        }
        if (StringUtil.equals((String)"uploadimage", (String)action)) {
            return this.actionUploadImage(file, imageType);
        }
        if (StringUtil.equals((String)"uploadvideo", (String)action)) {
            imageType = "uploadVideo";
            return this.actionUploadImage(file, imageType);
        }
        if (StringUtil.equals((String)"catchimage", (String)action)) {
            return this.xiuMiToCos(source, imageType);
        }
        return null;
    }

    private JSONObject actionConfig() {
        Ueditor ueditor = (Ueditor)((Object)this.ueditorService.select(JpaCriteria.builder().eq("appId", (Object)"0").eq("action", (Object)"config")));
        Checker.checkCondition((ueditor == null ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5668\u672a\u914d\u7f6e\uff0c\u8bf7\u5148\u5b8c\u6210\u914d\u7f6e");
        String json = ueditor.getConfigData();
        return JSONObject.parseObject((String)json);
    }

    private JSONObject actionUploadImage(MultipartFile file, String imageType) {
        CosAccess access;
        JSONObject json = new JSONObject();
        if (file == null || file.getSize() == 0L) {
            Shift.throwsIfInvalid((boolean)true, (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a\u6587\u4ef6\u5927\u5c0f\u4e3a0");
        }
        if ((access = EnvironmentUtil.createCosAccess((Environment)this.env)) == null) {
            Shift.throwsIfInvalid((boolean)true, (String)"cos\u672a\u6b63\u786e\u914d\u7f6e\uff0c\u65e0\u6cd5\u4e0a\u4f20\u6587\u4ef6\uff0c\u8bf7\u8054\u7cfb\u7ef4\u62a4\u4eba\u5458\u6216\u5ba2\u670d");
        }
        try {
            String originalFileName = file.getOriginalFilename();
            int index = originalFileName.lastIndexOf(".");
            String subfix = originalFileName.substring(index);
            String randonFileName = GuidGenerator.generate() + subfix;
            String formattedPath = FileUploadUtil.upload(file.getInputStream(), randonFileName, imageType, access);
            long fileSize = file.getSize();
            this.simpleRedisTemplate.set(formattedPath, (Object)fileSize, 600L);
            json.put("state", (Object)"SUCCESS");
            json.put("url", (Object)formattedPath);
            json.put("title", (Object)randonFileName);
            json.put("original", (Object)randonFileName);
            json.put("type", (Object)subfix);
            json.put("size", (Object)fileSize);
        }
        catch (Exception e) {
            json.put("state", (Object)"ERROR");
            Shift.throwsIfInvalid((boolean)true, (String)"\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
            this.logger.error("error", (Throwable)e);
        }
        return json;
    }

    private JSONObject xiuMiToCos(String[] source, String imageType) {
        JSONObject json = new JSONObject();
        LinkedList maps = new LinkedList();
        json.put("state", (Object)"SUCCESS");
        for (String str : source) {
            int index = str.lastIndexOf("?");
            if (!IntegerUtil.equals((Integer)index, (Integer)-1)) {
                str = str.substring(0, index);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            String cosPath = this.httpDownloadFile(str, imageType);
            map.put("state", "SUCCESS");
            map.put("url", cosPath);
            map.put("source", str);
            maps.add(map);
        }
        json.put("list", maps);
        return json;
    }

    public static void main(String[] args) {
        String url = "https://statics.xiumi.us/stc/images/templates-assets/tpl-paper/image/1d74ba058a5136b7a17fc91ccf51912a-sz_389327.jpg?x-oss-process=style/xmorient";
        url.lastIndexOf("?");
    }

    public String httpDownloadFile(String requestUrl, String imageType) {
        int index = requestUrl.lastIndexOf(".");
        String subfix = requestUrl.substring(index);
        String randonFileName = GuidGenerator.generate() + subfix;
        CosAccess access = EnvironmentUtil.createCosAccess((Environment)this.env);
        if (access == null) {
            Shift.throwsIfInvalid((boolean)true, (String)"cos\u672a\u6b63\u786e\u914d\u7f6e\uff0c\u65e0\u6cd5\u4e0a\u4f20\u56fe\u7247\uff0c\u8bf7\u8054\u7cfb\u7ef4\u62a4\u4eba\u5458\u6216\u5ba2\u670d");
        }
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(requestUrl).openConnection();
            connection.setReadTimeout(5000);
            connection.setConnectTimeout(5000);
            connection.setRequestMethod("GET");
            if (connection.getResponseCode() == 200) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)connection.getInputStream(), (OutputStream)output);
                return FileUploadUtil.upload(new ByteArrayInputStream(output.toByteArray()), randonFileName, imageType, access);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

