/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Page;
import com.wego168.base.domain.MiniProgramPage;
import com.wego168.base.service.MiniProgramPageService;
import com.wego168.domain.BaseDomain;
import com.wego168.util.BaseDomainUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.validation.constraints.UnsignedInteger;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class AdminMiniProgramPageController
extends SimpleController {
    @Autowired
    private MiniProgramPageService service;

    @GetMapping(value={"/api/admin/v1/mini-program-page/page"})
    public RestResponse selectPage(HttpServletRequest request) {
        Page page = this.buildPage(request);
        String appId = this.getAppId();
        List<MiniProgramPage> list = this.service.selectPage(appId, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/mini-program-page/get"})
    public RestResponse get(@NotBlankAndLength String id) {
        MiniProgramPage miniProgramPage = (MiniProgramPage)((Object)this.service.selectById(id));
        return RestResponse.success((Object)((Object)miniProgramPage), (String)"ok");
    }

    @PostMapping(value={"/api/admin/v1/mini-program-page/delete"})
    public RestResponse delete(@NotBlankAndLength String id) {
        this.service.deleteById(id);
        return RestResponse.success((String)"ok");
    }

    @PostMapping(value={"/api/admin/v1/mini-program-page/update"})
    public RestResponse update(@NotBlankAndLength String id, @NotBlankAndLength(min=1, message="\u9875\u9762\u540d\u79f0\u975e\u6cd5") String name, @NotBlankAndLength(min=1, max=256, message="\u9875\u9762\u8def\u5f84\u975e\u6cd5") String path, @RequestParam(name="sortNumber", required=false) @UnsignedInteger(regardBlankAsDefaultValue=false, message="\u5e8f\u53f7\u975e\u6cd5") String sortNumberString) {
        MiniProgramPage param = new MiniProgramPage();
        param.setId(id);
        param.setName(name);
        param.setPath(path);
        param.setSortNumber(Integer.parseInt(sortNumberString));
        this.service.updateSelective((Object)param);
        return RestResponse.success((String)"ok");
    }

    @PostMapping(value={"/api/admin/v1/mini-program-page/insert"})
    public RestResponse insert(@NotBlankAndLength(min=1, message="\u9875\u9762\u540d\u79f0\u975e\u6cd5") String name, @NotBlankAndLength(min=1, max=256, message="\u9875\u9762\u8def\u5f84\u975e\u6cd5") String path, @RequestParam(name="sortNumber", required=false) @UnsignedInteger(regardBlankAsDefaultValue=false, message="\u5e8f\u53f7\u975e\u6cd5") String sortNumberString) {
        MiniProgramPage miniProgramPage = new MiniProgramPage();
        BaseDomainUtil.initBaseDomain((BaseDomain)miniProgramPage, (String)this.getAppId());
        miniProgramPage.setName(name);
        miniProgramPage.setPath(path);
        miniProgramPage.setSortNumber(Integer.parseInt(sortNumberString));
        this.service.insert((Object)miniProgramPage);
        return RestResponse.success((Object)((Object)miniProgramPage), (String)"ok");
    }
}

