/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Content;
import com.wego168.base.domain.PersonIp;
import com.wego168.base.model.response.PersonIpAdminGetResponse;
import com.wego168.base.model.response.PersonIpAdminListResponse;
import com.wego168.base.service.ContentService;
import com.wego168.base.service.PersonIpService;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdminPersonIpController
extends SimpleController {
    @Autowired
    private ContentService contentService;
    @Autowired
    private PersonIpService personIpService;

    @GetMapping(value={"/api/admin/v1/person-ip/page"})
    public RestResponse selectPage(String name, HttpServletRequest request) {
        Page page = this.buildPage(request);
        String appId = this.getAppId();
        List<PersonIpAdminListResponse> list = this.personIpService.selectPageForAdmin(name, appId, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @PostMapping(value={"/api/admin/v1/person-ip/insert"})
    public RestResponse insert(String name, String headImage, String content, String introduction, @RequestParam(required=false, name="sortNumber") String sortNumberString) {
        try {
            Checker.checkBlankAndLength((String)name, (String)"\u540d\u79f0", (int)32);
            Checker.checkBlankAndLength((String)headImage, (String)"\u5934\u50cf", (int)256);
            Checker.checkBlank((String)content, (String)"\u5185\u5bb9");
            Checker.checkBlankOrLength((String)introduction, (String)"\u7b80\u4ecb", (int)512);
            if (StringUtil.isBlank((String)sortNumberString)) {
                sortNumberString = "0";
            }
            int sortNumber = Checker.checkStringIsUnsignedInteger((String)sortNumberString, (String)"\u5e8f\u53f7");
            String appId = this.getAppId();
            this.personIpService.insert(name, headImage, content, introduction, sortNumber, appId);
            return RestResponse.success((String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/person-ip/update"})
    public RestResponse update(String id, String name, String headImage, String content, String introduction, @RequestParam(required=false, name="sortNumber") String sortNumberString) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"id", (int)32);
            Checker.checkBlankAndLength((String)name, (String)"\u540d\u79f0", (int)32);
            Checker.checkBlankAndLength((String)headImage, (String)"\u5934\u50cf", (int)256);
            Checker.checkBlankOrLength((String)introduction, (String)"\u7b80\u4ecb", (int)512);
            Checker.checkBlank((String)content, (String)"\u5185\u5bb9");
            if (StringUtil.isBlank((String)sortNumberString)) {
                sortNumberString = "0";
            }
            int sortNumber = Checker.checkStringIsUnsignedInteger((String)sortNumberString, (String)"\u5e8f\u53f7");
            PersonIp personIpDb = (PersonIp)((Object)this.personIpService.selectById(id));
            Checker.checkCondition((personIpDb == null ? 1 : 0) != 0, (String)"\u8be5\u4eba\u7269ip\u4e0d\u5b58\u5728");
            String contentId = personIpDb.getContentId();
            this.personIpService.update(id, name, headImage, sortNumber, contentId, content, introduction);
            return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/admin/v1/person-ip/get"})
    public RestResponse get(String id) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"id", (int)32);
            PersonIp personIpDb = (PersonIp)((Object)this.personIpService.selectById(id));
            Checker.checkCondition((personIpDb == null ? 1 : 0) != 0, (String)"\u8be5\u4eba\u7269ip\u4e0d\u5b58\u5728");
            Content contentDb = (Content)this.contentService.selectById(personIpDb.getContentId());
            return RestResponse.success((Object)new PersonIpAdminGetResponse(personIpDb, contentDb));
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/person-ip/delete"})
    public RestResponse delete(String id) {
        try {
            Checker.checkBlankAndLength((String)id, (String)"id", (int)32);
            this.personIpService.updateDelete(id);
            return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

