/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.wego168.base.domain.PersonIp;
import com.wego168.base.domain.PersonIpObject;
import com.wego168.base.enums.PersonIpObjectTypeEnum;
import com.wego168.base.model.request.PersonIpObjectRequest;
import com.wego168.base.service.PersonIpObjectService;
import com.wego168.base.service.PersonIpService;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdminPersonIpObjectController
extends SimpleController {
    @Autowired
    private PersonIpService personIpService;
    @Autowired
    private PersonIpObjectService personIpObjectService;

    @PostMapping(value={"/api/admin/v1/person-ip-object/insert"})
    public RestResponse insert(@RequestBody PersonIpObjectRequest request) {
        try {
            List<PersonIpObject> requestPersonIpObjectList = this.validRequest(request);
            this.personIpObjectService.refresh(requestPersonIpObjectList);
            return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/person-ip-object/delete"})
    public RestResponse delete(@RequestBody PersonIpObjectRequest request) {
        try {
            if (request != null) {
                request.setObjectType(PersonIpObjectTypeEnum.PRODUCT.value());
            }
            List<PersonIpObject> requestPersonIpObjectList = this.validRequest(request);
            this.personIpObjectService.deleteList(requestPersonIpObjectList);
            return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    private List<PersonIpObject> validRequest(PersonIpObjectRequest request) {
        Checker.checkNull((Object)request, (String)"\u8bf7\u6c42\u53c2\u6570");
        String personIpId = request.getPersonIpId();
        List<String> objectIdList = request.getObjectIdList();
        String objectType = request.getObjectType();
        Checker.checkBlank((String)objectType, (String)"\u4eba\u7269\u5173\u8054\u5bf9\u8c61\u7c7b\u578b");
        Checker.checkInRange((Object)((Object)PersonIpObjectTypeEnum.get(objectType)), (Object[])PersonIpObjectTypeEnum.values(), (String)"\u9519\u8bef\u7684\u4eba\u7269\u5173\u8054\u5bf9\u8c61\u7c7b\u578b");
        Checker.checkBlankAndLength((String)personIpId, (String)"\u4eba\u7269ipid", (int)32);
        Checker.checkEmptyList(objectIdList, (String)"\u5173\u8054\u5bf9\u8c61");
        for (String objectId : objectIdList) {
            Checker.checkBlankAndLength((String)objectId, (String)"\u5173\u8054\u5bf9\u8c61id", (int)32);
        }
        PersonIp personIpDb = (PersonIp)((Object)this.personIpService.selectById(personIpId));
        Checker.checkCondition((personIpDb == null ? 1 : 0) != 0, (String)"\u8be5\u4eba\u7269ip\u4e0d\u5b58\u5728");
        ArrayList<PersonIpObject> PersonIpObjectList = new ArrayList<PersonIpObject>(objectIdList.size());
        for (String objectId : objectIdList) {
            PersonIpObject personIpObject = new PersonIpObject();
            personIpObject.setPersonIpId(personIpId);
            personIpObject.setObjectId(objectId);
            personIpObject.setObjectType(objectType);
            PersonIpObjectList.add(personIpObject);
        }
        return PersonIpObjectList;
    }
}

