/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Page;
import com.wego168.base.domain.App;
import com.wego168.base.domain.WechatShareConfig;
import com.wego168.base.service.AppService;
import com.wego168.base.service.WechatShareConfigService;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.EnvironmentUtil;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AdminWechatShareConfigController
extends CrudController<WechatShareConfig> {
    @Autowired
    private WechatShareConfigService wechatShareConfigService;
    @Autowired
    private AuthenticationUser authenticationUser;
    @Autowired
    private AppService appService;
    @Autowired
    private Environment env;

    public CrudService<WechatShareConfig> getService() {
        return this.wechatShareConfigService;
    }

    protected String getDomain() {
        return EnvironmentUtil.getDomain((Environment)this.env);
    }

    @RequestMapping(value={"/api/admin/v1/wechat_share_config/init"})
    public RestResponse initWechatShareConfig(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return RestResponse.error((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u4f20\u9012\u53c2\u6570type");
        }
        String appId = this.authenticationUser.getAppId();
        App app = this.appService.selectByAppId(appId);
        if (app == null) {
            return RestResponse.error((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0cAPP\u4e0d\u5b58\u5728");
        }
        int num = this.wechatShareConfigService.init(appId, app.getName(), app.getLogUrl(), this.getDomain() + "/" + app.getCode(), type);
        if (num == 0) {
            return RestResponse.error((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u6570\u636e\u53ef\u80fd\u5df2\u7ecf\u5b58\u5728");
        }
        return RestResponse.success((String)("\u6210\u529f\u6dfb\u52a0" + num + "\u6761\u6570\u636e"));
    }

    @PostMapping(value={"/api/admin/v1/wechat_share_config/insert"})
    public RestResponse addWechatShareConfig(String code, String title, String description, String image, String url) {
        this.checkAddParams(code, title, description, image, url);
        String appId = this.authenticationUser.getAppId();
        WechatShareConfig existWechatShareConfig = this.wechatShareConfigService.selectByCode(code, appId);
        if (existWechatShareConfig != null) {
            return RestResponse.error((String)"\u60a8\u8f93\u5165\u7684\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        WechatShareConfig config = this.wechatShareConfigService.create(code, title, description, image, url, appId);
        this.wechatShareConfigService.insert((Object)config);
        return RestResponse.success((Object)((Object)config), (String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/wechat_share_config/delete"})
    public RestResponse deleteWechatShareConfig(String id, HttpServletRequest request) {
        Checker.checkBlank((String)id, (String)"id");
        this.wechatShareConfigService.deleteById(id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/wechat_share_config/update"})
    public RestResponse updateWechatShareConfig(String title, String description, String image, String url, String id) {
        Checker.checkBlank((String)id, (String)"id");
        this.checkUpdateParams(title, description, image, url);
        this.wechatShareConfigService.update(title, description, image, url, id);
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/wechat_share_config/page"})
    public RestResponse selectList(HttpServletRequest request) {
        String appId = this.authenticationUser.getAppId();
        Page page = this.buildPage(request);
        List<WechatShareConfig> list = this.wechatShareConfigService.selectList(appId, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/wechat_share_config/get"})
    public RestResponse getWechatShareConfig(String id) {
        Checker.checkBlank((String)id, (String)"id");
        return super.get(id);
    }

    private void checkAddParams(String code, String title, String description, String image, String url) {
        Checker.checkBlank((String)code, (String)"\u7f16\u7801");
        this.checkUpdateParams(title, description, image, url);
    }

    private void checkUpdateParams(String title, String description, String image, String url) {
        Checker.checkBlank((String)title, (String)"\u6807\u9898");
        Checker.checkBlank((String)description, (String)"\u6458\u8981");
        Checker.checkBlank((String)image, (String)"\u56fe\u7247");
        Checker.checkBlank((String)url, (String)"\u94fe\u63a5");
    }
}

