/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Bootmap;
import com.wego168.base.domain.AppAbility;
import com.wego168.base.service.AppAbilityService;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController(value="adminAppAbilityController")
public class AppAbilityController
extends SimpleController {
    @Autowired
    private AppAbilityService service;

    @GetMapping(value={"/api/admin/v1/ability/tree"})
    public RestResponse getAbility(@NotBlankAndLength(message="appid\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String appId) {
        return RestResponse.success(this.service.getTree(appId));
    }

    @PostMapping(value={"/api/admin/v1/ability/update-value"})
    public RestResponse updateValue(@NotBlankAndLength String id, @NotBlankAndLength(min=1, max=32, message="\u503c\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String value) {
        AppAbility param = new AppAbility();
        param.setId(id);
        param.setValue(value);
        param.setUpdateTime(new Date());
        this.service.updateSelective(param);
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1.1/ability/update-value"})
    public RestResponse updateValue2(@NotBlankAndLength(min=1, max=64, message="code\u975e\u6cd5") String code, @NotBlankAndLength(min=1, max=32, message="\u503c\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String value) {
        String appId = super.getAppId();
        this.service.updateValueByCode(appId, code, value);
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/ability/get"})
    public RestResponse get(@NotBlankAndLength(min=1, max=64, message="code\u7684\u957f\u5ea6\u5fc5\u987b\u57281~64\u5b57\u7b26\u4e4b\u95f4") String code) {
        String appId = this.getAppId();
        AppAbility ability = this.service.selectByCode(appId, code);
        Bootmap response = new Bootmap();
        response.put((Object)"name", (Object)ability.getName());
        response.put((Object)"description", (Object)ability.getDescription());
        response.put((Object)"code", (Object)code);
        response.put((Object)"showType", (Object)ability.getShowType());
        response.put((Object)"value", (Object)ability.getValue());
        response.put((Object)"valueRange", (Object)ability.getValueRange());
        response.put((Object)"open", (Object)this.service.isOpen(appId, code));
        response.put((Object)"id", (Object)ability.getId());
        return RestResponse.success((Object)response);
    }

    @GetMapping(value={"/api/admin/v1/ability-is-open/{code}"})
    public RestResponse isOpen(@PathVariable String code) {
        String appId = this.getAppId();
        return RestResponse.success((Object)this.service.isOpen(appId, code));
    }
}

