/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.AppAbilityTemplate;
import com.wego168.base.domain.FileServer;
import com.wego168.base.enums.AppAbilityShowTypeEnum;
import com.wego168.base.service.AppAbilityTemplateService;
import com.wego168.base.service.FileServerService;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.validation.constraints.NotBlankOrLength;
import com.wego168.validation.constraints.UnsignedInteger;
import com.wego168.web.response.RestResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class AppAbilityTemplateController {
    @Autowired
    private AppAbilityTemplateService service;
    @Autowired
    private FileServerService fileServerService;

    @PostMapping(value={"/api/admin/v1/ability-template/insert"})
    public RestResponse insert(@NotBlankAndLength(min=1, message="\u540d\u79f0\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String name, @NotBlankAndLength(min=1, message="\u7f16\u7801\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String code, @NotBlankAndLength(min=1, message="\u663e\u793a\u7c7b\u578b\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String showType, @NotBlankOrLength(min=1, max=256, message="\u56fe\u6807\u957f\u5ea6\u5fc5\u987b\u57281~256\u5b57\u7b26\u4e4b\u95f4") String icon, @NotBlankOrLength(min=1, max=512, message="\u503c\u8303\u56f4\u957f\u5ea6\u5fc5\u987b\u5728\u57281~512\u5b57\u7b26\u4e4b\u95f4") String valueRange, @NotBlankOrLength(min=1, max=64, message="\u503c\u957f\u5ea6\u5fc5\u987b\u5728\u57281~64\u5b57\u7b26\u4e4b\u95f4") String value, @NotBlankOrLength(min=1, max=128, message="\u8bf4\u660e\u957f\u5ea6\u5fc5\u987b\u5728\u57281~128\u5b57\u7b26\u4e4b\u95f4") String description, @UnsignedInteger(message="\u5e8f\u53f7\u5fc5\u987b\u662f\u975e\u8d1f\u6574\u6570") String sortNumber, @NotBlankOrLength(min=1, message="\u7236\u529f\u80fd\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String parentCode) {
        try {
            if (StringUtil.isBlank((String)sortNumber)) {
                sortNumber = "0";
            }
            Checker.checkCondition((!AppAbilityShowTypeEnum.isValid(showType) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u663e\u793a\u7c7b\u578b");
            int level = 1;
            if (StringUtil.isNotBlank((String)parentCode)) {
                AppAbilityTemplate parentTemplate = this.service.selectByCode(parentCode);
                Checker.checkCondition((parentTemplate == null ? 1 : 0) != 0, (String)"\u7236\u529f\u80fd\u4e0d\u5b58\u5728");
                level = parentTemplate.getLevel() + 1;
            }
            Checker.checkCondition((boolean)this.service.existSameCode(code), (String)"\u51b2\u7a81\u7684code");
            FileServer server = this.fileServerService.ensure();
            String serverId = server.getId();
            AppAbilityTemplate template = this.service.create(level, name, code, description, icon, parentCode, serverId, Integer.parseInt(sortNumber), showType, value, valueRange);
            this.service.insert(template);
            return RestResponse.success((Object)template, (String)"\u6dfb\u52a0\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/ability-template/delete"})
    public RestResponse delete(@NotBlankAndLength(min=1, max=64, message="\u7f16\u7801\u957f\u5ea6\u5fc5\u987b\u57281~64\u5b57\u7b26\u4e4b\u95f4") String code) {
        try {
            this.service.deleteByCode(code);
            return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @PostMapping(value={"/api/admin/v1/ability-template/update"})
    public RestResponse update(@NotBlankAndLength(min=1, message="\u540d\u79f0\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String name, @NotBlankAndLength(min=1, message="\u663e\u793a\u7c7b\u578b\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String showType, @NotBlankOrLength(min=1, max=256, message="\u56fe\u6807\u957f\u5ea6\u5fc5\u987b\u57281~256\u5b57\u7b26\u4e4b\u95f4") String icon, @NotBlankOrLength(min=1, max=512, message="\u503c\u8303\u56f4\u957f\u5ea6\u5fc5\u987b\u5728\u57281~512\u5b57\u7b26\u4e4b\u95f4") String valueRange, @NotBlankOrLength(min=1, max=64, message="\u503c\u957f\u5ea6\u5fc5\u987b\u5728\u57281~64\u5b57\u7b26\u4e4b\u95f4") String value, @NotBlankOrLength(min=1, max=128, message="\u8bf4\u660e\u957f\u5ea6\u5fc5\u987b\u5728\u57281~128\u5b57\u7b26\u4e4b\u95f4") String description, @UnsignedInteger(message="\u5e8f\u53f7\u5fc5\u987b\u662f\u975e\u8d1f\u6574\u6570") String sortNumber, @NotBlankAndLength(min=1, message="id\u957f\u5ea6\u5fc5\u987b\u57281~32\u5b57\u7b26\u4e4b\u95f4") String id) {
        try {
            if (StringUtil.isBlank((String)sortNumber)) {
                sortNumber = "0";
            }
            Checker.checkCondition((!AppAbilityShowTypeEnum.isValid(showType) ? 1 : 0) != 0, (String)"\u9519\u8bef\u7684\u663e\u793a\u7c7b\u578b");
            AppAbilityTemplate param = new AppAbilityTemplate();
            param.setId(id);
            param.setName(name);
            param.setShowType(showType);
            param.setIcon(icon);
            param.setValueRange(valueRange);
            param.setValue(value);
            param.setDescription(description);
            param.setSortNumber(Integer.parseInt(sortNumber));
            this.service.updateSelective(param);
            return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/admin/v1/ability-template/list"})
    public RestResponse selectList() {
        try {
            List list = this.service.selectList(JpaCriteria.builder().orderBy("level ASC, sortNumber ASC"));
            return RestResponse.success((Object)list, (String)"ok");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }
}

