/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.config.ServerConfig;
import com.wego168.base.domain.App;
import com.wego168.base.enums.AppStatusEnum;
import com.wego168.base.service.AppService;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.service.InitApp;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.GuidGenerator;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/v1/app"})
public class AppController
extends CrudController<App> {
    @Autowired
    private AppService appService;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private ServerConfig serverConfig;

    public CrudService<App> getService() {
        return this.appService;
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5355\u4e2a\u5e94\u7528")
    @GetMapping(value={"/get"})
    public RestResponse get(String id) {
        return super.get(id);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5e94\u7528\u5217\u8868")
    @GetMapping(value={"/list"})
    public RestResponse list(HttpServletRequest request) {
        return super.list(request);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e94\u7528")
    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.eq("isDeleted", (Object)false).eq("isTemplate").eq("status").like("name").like("customerName").orderBy("createTime desc");
        List list = this.appService.selectPage(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @ApiOperation(value="\u6dfb\u52a0\u5e94\u7528")
    @PostMapping(value={"/insert"})
    public RestResponse insert(@Valid @RequestBody App app) {
        boolean isTemplate;
        String code = app.getCode().replaceAll(":?([^(a-zA-Z0-9)])", "");
        int count = this.appService.selectCount(JpaCriteria.builder().eq("code", (Object)code));
        Shift.throwsIfInvalid((count > 0 ? 1 : 0) != 0, (String)"\u7f16\u53f7\u5df2\u5b58\u5728");
        app.setCode(code);
        String id = GuidGenerator.generate();
        boolean bl = isTemplate = app.getIsTemplate() != null && app.getIsTemplate() != false;
        if (isTemplate) {
            int length = 32 - code.length();
            id = code + String.format("%0" + length + "d", 0);
        }
        app.setId(id);
        app.setAppId(id);
        app.setIsDeleted(false);
        app.setStatus(AppStatusEnum.NORMAL.value());
        app.setCreateTime(new Date());
        this.appService.insert((Object)app);
        this.simpleRedisTemplate.set(app.getCode(), (Object)app);
        if (isTemplate) {
            String templateAppId = app.getCopyTemplateAppId();
            if (StringUtils.isNotBlank((CharSequence)templateAppId)) {
                InitApp.copyData((String)templateAppId, (String)id);
            } else {
                InitApp.initByAppId((String)id);
            }
        } else {
            InitApp.initByAppId((String)id);
        }
        return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    public static void main(String[] args) {
        String str = "a b---c,,,d#%$*((123\u5443\u5443";
        str = str.replaceAll(":?([^(a-zA-Z0-9)])", "");
        System.out.println(str);
        int length = 32 - str.length();
        System.out.println(str + String.format("%0" + length + "d", 0));
    }

    @ApiOperation(value="\u521d\u59cb\u5316\u5e94\u7528\u6570\u636e")
    @RequestMapping(value={"/init"})
    public RestResponse init(String appId) {
        InitApp.initByAppId((String)appId);
        return RestResponse.success((String)"\u521d\u59cb\u5316\u6210\u529f");
    }

    @ApiOperation(value="\u4ece\u6a21\u677f\u590d\u5236\u5e94\u7528\u6570\u636e")
    @RequestMapping(value={"/copyData"})
    public RestResponse copyData(String templateAppId, String appId) {
        InitApp.copyData((String)templateAppId, (String)appId);
        return RestResponse.success((String)"\u590d\u5236\u6210\u529f");
    }

    @ApiOperation(value="\u66f4\u65b0\u5e94\u7528")
    @PostMapping(value={"/update"})
    public RestResponse update(@Valid @RequestBody App app) {
        String code = app.getCode().replaceAll(":?([^(a-zA-Z0-9)])", "");
        app.setCode(code);
        this.appService.updateApp(app);
        return RestResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u94fe\u63a5")
    @GetMapping(value={"/getAppLink"})
    public RestResponse getAppLink(String id) {
        Shift.throwsIfBlank((String)id, (String)"\u5e94\u7528id\u4e0d\u80fd\u4e3a\u7a7a");
        App app = (App)((Object)this.appService.selectById(id));
        Shift.throwsIfNull((Object)((Object)app), (String)"\u5e94\u7528\u4e0d\u5b58\u5728");
        String link = this.serverConfig.getDomain() + "/" + app.getCode();
        Bootmap bootmap = new Bootmap();
        bootmap.put((Object)"link", (Object)link);
        return RestResponse.success((Object)bootmap);
    }

    @ApiOperation(value="\u83b7\u53d6\u5e94\u7528\u624b\u673a\u7aef\u8bbf\u95ee\u94fe\u63a5")
    @GetMapping(value={"/getMobileUrl"})
    public RestResponse getPreUrl(HttpServletRequest request) {
        String id = this.getAppId();
        App app = (App)((Object)this.appService.selectById(id));
        String link = this.serverConfig.getDomain();
        link = app == null ? link + request.getContextPath() : link + "/" + app.getCode();
        Bootmap bootmap = new Bootmap();
        bootmap.put((Object)"url", (Object)link);
        return RestResponse.success((Object)bootmap);
    }

    @ApiOperation(value="\u66f4\u65b0\u5e94\u7528\u8fc7\u671f\u72b6\u6001")
    @PostMapping(value={"/updateStatus"})
    public RestResponse updateAppStatus() {
        this.appService.updateAppStatus();
        return RestResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }
}

