/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.wego168.base.domain.CalendarEvent;
import com.wego168.base.domain.Config;
import com.wego168.base.service.CalendarEventService;
import com.wego168.base.service.ConfigService;
import com.wego168.service.CrudService;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminCalendarEventController")
@RequestMapping(value={"/api/admin/v1/calendarEvent"})
public class CalendarEventController
extends CrudController<CalendarEvent> {
    @Autowired
    private CalendarEventService calendarEventService;
    @Autowired
    private ConfigService configService;

    public CrudService<CalendarEvent> getService() {
        return this.calendarEventService;
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5355\u4e2a\u65e5\u7a0b")
    @GetMapping(value={"/get"})
    public RestResponse get(String id) {
        return super.get(id);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u65e5\u7a0b\u5217\u8868")
    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request) {
        return super.page(request);
    }

    @ApiOperation(value="\u6dfb\u52a0\u65e5\u7a0b")
    @PostMapping(value={"/insert"})
    public RestResponse insert(CalendarEvent vo) {
        this.calendarEventService.insert((Object)vo);
        return RestResponse.success((Object)((Object)vo));
    }

    @ApiOperation(value="\u66f4\u65b0\u65e5\u7a0b")
    @PostMapping(value={"/update"})
    public RestResponse update(CalendarEvent vo) {
        this.calendarEventService.updateSelective((Object)vo);
        return RestResponse.success((Object)((Object)vo));
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u65e5\u7a0b")
    @PostMapping(value={"/delete"})
    public RestResponse delete(String id) {
        return super.delete(id);
    }

    @ApiOperation(value="\u83b7\u53d6\u63d0\u9192\u65f6\u95f4")
    @GetMapping(value={"/remaindTime"})
    public RestResponse getRemaindTime(@DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss") Date startTime, String aheadTime) {
        Config config = this.configService.getByKey("calendar_config");
        String value = config.getValue();
        Date remaindTime = this.calendarEventService.getRemaindTime(startTime, value, aheadTime);
        return RestResponse.success((Object)remaindTime);
    }
}

