/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Bootmap;
import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Category;
import com.wego168.base.interceptor.ApiLog;
import com.wego168.base.request.CategoryRrequest;
import com.wego168.base.service.CategoryService;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.Shift;
import com.wego168.util.SimpleTree;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminCategoryController")
public class CategoryController
extends CrudController<Category> {
    @Autowired
    private CategoryService categoryService;

    public CrudService<Category> getService() {
        return this.categoryService;
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5355\u4e2a\u7c7b\u522b")
    @GetMapping(value={"/api/admin/v1/category/get"})
    public RestResponse get(String id) {
        return super.get(id);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7c7b\u522b\u5217\u8868")
    @GetMapping(value={"/api/admin/v1/category/list"})
    public RestResponse list(HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.eq("type").eq("parentId");
        page.eq("isDisplay", (Object)true);
        return RestResponse.success((Object)this.categoryService.selectList((JpaCriteria)page));
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/api/admin/v1/category/listByType"})
    public RestResponse listByType(Integer type) {
        List<Category> list = this.categoryService.listByTypeAll(type);
        return RestResponse.success(list);
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u6811\u7ed3\u6784")
    @GetMapping(value={"/api/admin/v1/category/treeByType"})
    public RestResponse treeByType(Integer type) {
        List<Category> list = this.categoryService.listByTypeAll(type);
        SimpleTree simpleTree = new SimpleTree();
        List treeList = simpleTree.initTree(list);
        return RestResponse.success((Object)treeList);
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u6811\u7ed3\u6784\u5e76\u6309\u7167\u7b2c\u4e00\u7ea7\u5206\u7c7b\u5206\u9875")
    @GetMapping(value={"/api/admin/v1/category/treeByTypePage"})
    public RestResponse treeByTypePage(Integer type, String name, HttpServletRequest request) {
        Page page = this.buildPage(request);
        Category param = new Category();
        param.setType(type);
        param.setName(name);
        List<Category> list = this.categoryService.listByTypeAll(param);
        SimpleTree simpleTree = new SimpleTree();
        List treeList = simpleTree.initTree(list);
        page.setList(treeList);
        return RestResponse.success((Object)page);
    }

    @ApiOperation(value="\u6839\u636eparentId\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/api/admin/v1/category/listByParentId"})
    public RestResponse listByParentId(String parentId) {
        List<Category> list = this.categoryService.selectListByParentIdAll(parentId);
        return RestResponse.success(list);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7c7b\u522b")
    @GetMapping(value={"/api/admin/v1/category/page"})
    public RestResponse page(HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.eq("type").eq("parentId").eq("storeId").orderBy("seqNum asc").eq("appId");
        List lists = this.getService().selectPage(page);
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    @ApiLog(value="\u6dfb\u52a0\u5206\u7c7b")
    @PostMapping(value={"/api/admin/v1/category/insert"})
    public RestResponse insert(@Valid @RequestBody Category vo) {
        vo.setAppId(this.getAppId());
        vo.setCode(this.categoryService.getByCode(vo));
        return super.insert((Object)vo);
    }

    @ApiLog(value="\u66f4\u65b0\u5206\u7c7b")
    @PostMapping(value={"/api/admin/v1/category/update"})
    public RestResponse update(@Valid @RequestBody Category vo) {
        vo.setAppId(this.getAppId());
        vo.setCode(this.categoryService.getByCode(vo));
        return super.update((Object)vo);
    }

    @ApiLog(value="\u6839\u636eID\u5220\u9664\u7c7b\u522b")
    @PostMapping(value={"/api/admin/v1/category/delete"})
    public RestResponse delete(String id) {
        int row = this.categoryService.updateDelete(id);
        return this.responseByRows(row);
    }

    @ApiOperation(value="\u901a\u8fc7\u5206\u7c7b\u4ee3\u7801\u83b7\u53d6\u5206\u7c7b\uff0c\u7528\u4e8e\u5e7f\u544a\u4f4d\u56fe\u7247\u4e4b\u7c7b\u7684\u65b0\u589e")
    @GetMapping(value={"/api/admin/v1/category/getIdByCode"})
    public RestResponse getIdByCode(String categoryCode) {
        Category category = this.categoryService.selectByCode(categoryCode);
        Shift.throwsIfNull((Object)category, (String)"\u5206\u7c7bcode\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        Bootmap bootmap = new Bootmap();
        bootmap.put((Object)"categoryId", (Object)category.getId());
        return RestResponse.success((Object)bootmap);
    }

    @GetMapping(value={"/api/admin/v1/category/listChildsByType"})
    public RestResponse listChildsByType(int type) {
        List<Category> categoryList = this.categoryService.listChildsByType(type);
        return RestResponse.success(categoryList);
    }

    @Deprecated
    @ApiLog(value="\u66f4\u65b0\u5206\u7c7b\uff08\u5e9f\u5f03\uff09")
    @PostMapping(value={"/api/admin/v1/category/edit"})
    public RestResponse insert(@Valid @RequestBody CategoryRrequest param) {
        List<Category> list = param.getList();
        Integer type = param.getType();
        this.categoryService.editCategoryList(list, type);
        return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/category/init"})
    public RestResponse init(String type) {
        Checker.checkBlank((String)type, (String)"\u5206\u7c7b\u7c7b\u578b");
        String appId = this.getAppId();
        int rows = this.categoryService.init(appId, type);
        return RestResponse.success((Object)rows, (String)"ok");
    }
}

