/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import com.simple.mybatis.Page;
import com.wego168.base.advice.DateTimeUtil;
import com.wego168.base.domain.Checkin;
import com.wego168.base.domain.SignData;
import com.wego168.base.enums.CheckWayEnum;
import com.wego168.base.service.CheckinService;
import com.wego168.base.service.SignDataService;
import com.wego168.service.CrudService;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ValidationException;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminCheckinController")
@RequestMapping(value={"/api/admin/v1/checkin"})
public class CheckinController
extends CrudController<Checkin> {
    @Autowired
    private CheckinService checkinService;
    @Autowired
    private SignDataService signDataService;
    @Autowired
    private Environment environment;

    public CrudService<Checkin> getService() {
        return this.checkinService;
    }

    @ApiOperation(value="\u7b7e\u5230\u8bb0\u5f55\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request) {
        Page page = this.buildPage(request);
        List<Checkin> list = this.checkinService.getPage(page);
        if (list != null && list.size() > 0) {
            LinkedList<String> dataIdList = new LinkedList<String>();
            for (Checkin checkin : list) {
                dataIdList.add(checkin.getDataId());
            }
            List<SignData> datas = this.signDataService.selectByDataIds(dataIdList, false);
            if (this.isPhoneDisplay()) {
                this.phoneDisplay(datas);
            }
            HashMap signMap = new HashMap();
            for (SignData sg : datas) {
                String dataId = sg.getDataId();
                if (!signMap.containsKey(dataId)) {
                    signMap.put(dataId, new LinkedList());
                }
                List tempList = (List)signMap.get(dataId);
                tempList.add(sg);
            }
            for (Checkin checkin : list) {
                checkin.setSignDataList((List)signMap.get(checkin.getDataId()));
            }
        }
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/exportCheckData"})
    public void exprotDateV(HttpServletRequest request, HttpServletResponse response) {
        Page page = this.buildPage(request);
        page.setCount(false);
        page.setPageSize(Integer.MAX_VALUE);
        List<Checkin> list = this.checkinService.getPage(page);
        if (list != null && list.size() > 0) {
            LinkedList<String> dataIdList = new LinkedList<String>();
            for (Checkin checkin : list) {
                dataIdList.add(checkin.getDataId());
            }
            List<SignData> datas = this.signDataService.selectByDataIds(dataIdList, false);
            HashMap signMap = new HashMap();
            for (SignData sg : datas) {
                String dataId = sg.getDataId();
                if (!signMap.containsKey(dataId)) {
                    signMap.put(dataId, new LinkedList());
                }
                List tempList = (List)signMap.get(dataId);
                tempList.add(sg);
            }
            for (Checkin checkin : list) {
                checkin.setSignDataList((List)signMap.get(checkin.getDataId()));
            }
        }
        ArrayList<ExcelExportEntity> entity = new ArrayList<ExcelExportEntity>();
        ArrayList lists = new ArrayList();
        if (list.size() > 0) {
            List<SignData> signDatas = list.get(0).getSignDataList();
            if (signDatas != null) {
                for (SignData signData : signDatas) {
                    ExcelExportEntity excelExportEntity = new ExcelExportEntity(signData.getName());
                    excelExportEntity.setWidth(20.0);
                    entity.add(new ExcelExportEntity(signData.getName(), (Object)signData.getName(), 20));
                }
            }
            entity.add(new ExcelExportEntity("\u6635\u79f0", (Object)"name", 20));
            entity.add(new ExcelExportEntity("\u7b7e\u5230\u65b9\u5f0f", (Object)"checkWay", 20));
            entity.add(new ExcelExportEntity("\u662f\u5426\u8fdf\u5230", (Object)"isLate", 20));
            entity.add(new ExcelExportEntity("\u7b7e\u5230\u65f6\u95f4", (Object)"checkinTime", 20));
            for (Checkin ck : list) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (ck != null && null != ck.getSignDataList()) {
                    for (SignData signData : ck.getSignDataList()) {
                        map.put(signData.getName(), null == signData.getValue() ? "" : signData.getValue());
                    }
                }
                map.put("name", ck.getNickName());
                String checkWay = "";
                if (CheckWayEnum.MOBILE.getIndex().equals(ck.getCheckWay())) {
                    checkWay = CheckWayEnum.MOBILE.getName();
                } else if (CheckWayEnum.CODE.getIndex().equals(ck.getCheckWay())) {
                    checkWay = CheckWayEnum.CODE.getName();
                } else if (CheckWayEnum.QRCODE.getIndex().equals(ck.getCheckWay())) {
                    checkWay = CheckWayEnum.QRCODE.getName();
                } else if (CheckWayEnum.CHECK_CODE.getIndex().equals(ck.getCheckWay())) {
                    checkWay = CheckWayEnum.CHECK_CODE.getName();
                } else if (CheckWayEnum.AIRBORNE.getIndex().equals(ck.getCheckWay())) {
                    checkWay = CheckWayEnum.AIRBORNE.getName();
                }
                map.put("checkWay", checkWay);
                map.put("isLate", ck.getIsLate() != false ? "\u662f" : "\u5426");
                map.put("checkinTime", DateTimeUtil.format(ck.getCheckinTime(), "yyyy-MM-dd HH:mm:ss"));
                lists.add(map);
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u7b7e\u5230\u5217\u8868");
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entity, lists);
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u7b7e\u5230\u5217\u8868.xls", "UTF-8"));
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    private void phoneDisplay(List<SignData> signDatas) {
        for (SignData signData : signDatas) {
            if (!"\u624b\u673a".equals(signData.getName()) || !StringUtil.isNotBlank((String)signData.getName())) continue;
            String phone = signData.getValue();
            signData.setValue(phone.substring(0, 3) + "****" + phone.substring(7, phone.length()));
        }
    }

    private boolean isPhoneDisplay() {
        try {
            String flag = this.environment.getProperty("phoneDisplay");
            if ("true".equalsIgnoreCase(flag)) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

