/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Comment;
import com.wego168.base.domain.Commentable;
import com.wego168.base.service.CommentService;
import com.wego168.base.service.callback.Callback;
import com.wego168.domain.GenericDomain;
import com.wego168.util.Checker;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public abstract class CommentControllerSupport
extends SimpleController {
    public RestResponse selectPageWithoutSubComments(String sourceId, Integer auditStatus, HttpServletRequest request) {
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        CommentService commentService = this.getCommentService();
        Page page = this.buildPage(request);
        List<Comment> list = commentService.selectPageWithoutSubComments(sourceId, auditStatus, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    public RestResponse get(String sourceId) {
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        CommentService commentService = this.getCommentService();
        return RestResponse.success((Object)((Object)commentService.selectById(sourceId)));
    }

    public RestResponse auditComment(String sourceId, String userId) {
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        CommentService commentService = this.getCommentService();
        commentService.auditComment(sourceId, userId);
        return RestResponse.success((String)"\u5ba1\u6838\u6210\u529f");
    }

    public RestResponse refuseComment(String sourceId, String userId) {
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        CommentService commentService = this.getCommentService();
        commentService.refuseComment(sourceId, userId);
        return RestResponse.success((String)"\u62d2\u7edd\u5ba1\u6838\u6210\u529f");
    }

    public RestResponse deleteComment(String id) {
        Comment comment = this.getCommentService().selectById(id);
        if (comment == null) {
            return RestResponse.error((String)"\u8be5\u8bc4\u8bba\u4e0d\u5b58\u5728");
        }
        GenericDomain source = this.sourceIsValid(comment.getSourceId(), comment.getSourceType());
        if (source == null) {
            return RestResponse.error((String)"\u9519\u8bef\u7684\u6765\u6e90");
        }
        if (source instanceof Commentable) {
            this.getCommentService().deleteComment(id, (Commentable)source, new Callback<Commentable>(){

                @Override
                public Commentable execute(Commentable commentable) {
                    commentable.setCommentQuantity(commentable.getCommentQuantity() - 1);
                    CommentControllerSupport.this.getCommentService().updateCommentQuantity(commentable);
                    return commentable;
                }
            });
        } else {
            this.getCommentService().deleteById(id);
        }
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    protected abstract CommentService getCommentService();

    protected abstract GenericDomain sourceIsValid(String var1, Integer var2);
}

