/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.github.stuxuhai.jpinyin.PinyinException;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.Config;
import com.wego168.base.enums.ConfigTypeEnum;
import com.wego168.base.persistence.ConfigMapper;
import com.wego168.base.service.ConfigService;
import com.wego168.service.CrudService;
import com.wego168.util.SequenceUtil;
import com.wego168.util.SimpleTree;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.GuidGenerator;
import com.wego168.web.util.ServletContextHolder;
import io.swagger.annotations.ApiOperation;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminConfigController")
@RequestMapping(value={"/api/admin/v1/config"})
public class ConfigController
extends CrudController<Config> {
    @Autowired
    private ConfigService configService;
    @Autowired
    private ConfigMapper configMapper;

    public CrudService<Config> getService() {
        return this.configService;
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5355\u4e2a\u914d\u7f6e")
    @GetMapping(value={"/get"})
    public RestResponse get(String id) {
        return super.get(id);
    }

    @ApiOperation(value="\u6839\u636ekey\u83b7\u53d6value")
    @GetMapping(value={"/{key}"})
    public RestResponse getByKey(@PathVariable(name="key") String key) {
        Config config = this.configService.getByKey(key);
        return RestResponse.success((Object)((Object)config));
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u914d\u7f6e\u5217\u8868")
    @GetMapping(value={"/list"})
    public RestResponse list(HttpServletRequest request) {
        return super.list(request);
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/listByType"})
    public RestResponse listByType(Integer type) {
        List list = this.configService.selectList(JpaCriteria.builder().eq("type", (Object)type));
        return RestResponse.success((Object)list);
    }

    @ApiOperation(value="\u6839\u636eparentId\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/listByParentId"})
    public RestResponse listByParentId(String parentId) {
        List list = this.configService.selectList(JpaCriteria.builder().eq("parentId", (Object)parentId).orderBy("seqNum asc"));
        return RestResponse.success((Object)list);
    }

    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u6811\u7ed3\u6784\uff0c\u7528\u4e8e\u7cfb\u7edf\u914d\u7f6e\u7ef4\u62a4")
    @GetMapping(value={"/manageConfigTree"})
    public RestResponse manageMenuTree(Integer type) {
        if (type == null) {
            type = ConfigTypeEnum.SYSTEM.getIndex();
        }
        List list = this.configService.selectList(JpaCriteria.builder().eq("type", (Object)type).eq("isDeleted", (Object)false).orderBy("seqNum asc"));
        SimpleTree simpleTree = new SimpleTree();
        List treeList = simpleTree.initTree(list);
        return RestResponse.success((Object)treeList);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u914d\u7f6e")
    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request) {
        return super.page(request);
    }

    @ApiOperation(value="\u6dfb\u52a0\u914d\u7f6e")
    @PostMapping(value={"/insert"})
    public RestResponse insert(@Valid @RequestBody Config vo) {
        if (StringUtil.isNotBlank((String)vo.getParentId()) && vo.getParentId().equals("SHOPPING_LOGISTICS_COMPANY")) {
            try {
                String pinyin = PinyinHelper.getShortPinyin((String)vo.getValue());
                if (this.getService().selectList(JpaCriteria.builder().eq("key", (Object)pinyin)).size() == 0) {
                    vo.setKey(pinyin);
                } else {
                    vo.setKey(SequenceUtil.createUuid());
                }
            }
            catch (PinyinException e) {
                e.printStackTrace();
                return RestResponse.error((String)"\u6dfb\u52a0\u5931\u8d25");
            }
        }
        int row = this.getService().insert((Object)vo);
        return this.responseByRows(row);
    }

    @ApiOperation(value="\u66f4\u65b0\u914d\u7f6e")
    @PostMapping(value={"/update"})
    public RestResponse update(@Valid @RequestBody Config vo) {
        int row;
        if (StringUtil.isNotBlank((String)vo.getParentId()) && vo.getParentId().equals("SHOPPING_LOGISTICS_COMPANY")) {
            try {
                String pinyin = PinyinHelper.getShortPinyin((String)vo.getValue());
                if (this.getService().selectList(JpaCriteria.builder().eq("key", (Object)pinyin)).size() == 0) {
                    vo.setKey(pinyin);
                } else {
                    vo.setKey(SequenceUtil.createUuid());
                }
            }
            catch (PinyinException e) {
                e.printStackTrace();
                return RestResponse.error((String)"\u66f4\u65b0\u5931\u8d25");
            }
        }
        if ((row = this.configService.updateSelective((Object)vo)) == 1) {
            this.configService.setCache(vo);
        }
        return RestResponse.success((Object)row);
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u914d\u7f6e")
    @PostMapping(value={"/delete"})
    public RestResponse delete(String id) {
        int row = 0;
        Config config = (Config)((Object)this.configService.selectById(id));
        if (config != null) {
            config.setIsDeleted(true);
            row = this.configService.update((Object)config);
            if (row == 1) {
                this.configService.removeCache(config);
            }
        }
        return this.responseByRows(row);
    }

    @GetMapping(value={"/listByParentIdIfAbsentToInit"})
    public RestResponse listByParentIdIfAbsentToInit(String parentId) {
        List list = this.configService.selectList(JpaCriteria.builder().eq("parentId", (Object)parentId).orderBy("seqNum asc"));
        if ((list == null || list.size() == 0) && (list = this.configMapper.selectList(JpaCriteria.builder().eq("parentId", (Object)parentId).eq("appId", (Object)"templatexsj000000000000000000000").orderBy("seqNum asc"))) != null && list.size() > 0) {
            LinkedList<Config> results = new LinkedList<Config>();
            for (Config cfgDb : list) {
                Config config = new Config();
                BeanUtils.copyProperties((Object)((Object)cfgDb), (Object)((Object)config));
                config.setId(GuidGenerator.generate());
                config.setAppId(this.getAppId());
                results.add(config);
            }
            this.configService.insertBatch(results);
        }
        return RestResponse.success((Object)list);
    }

    @RequestMapping(value={"/init"})
    public RestResponse addWechatShareConfig(String type, String appId) {
        int num;
        if (StringUtils.isBlank((CharSequence)type)) {
            return RestResponse.error((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u4f20\u9012\u53c2\u6570type");
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = ServletContextHolder.getAppId();
        }
        if ((num = this.configService.init(appId, type)) == 0) {
            return RestResponse.error((String)"\u521d\u59cb\u5316\u5931\u8d25\uff0c\u6570\u636e\u53ef\u80fd\u5df2\u7ecf\u5b58\u5728");
        }
        return RestResponse.success((String)("\u6210\u529f\u6dfb\u52a0" + num + "\u6761\u6570\u636e"));
    }
}

