/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.CosBucket;
import com.wego168.base.service.CosBucketService;
import com.wego168.base.util.COSClientUtil;
import com.wego168.service.CrudService;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import com.wego168.web.util.GuidGenerator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="AdminCosBucketController")
@RequestMapping(value={"/api/admin/v1/cosBucket"})
public class CosBucketController
extends CrudController<CosBucket> {
    @Autowired
    private CosBucketService cosBucketService;

    public CrudService<CosBucket> getService() {
        return this.cosBucketService;
    }

    @PostMapping(value={"/insert"})
    public RestResponse insert(@Valid CosBucket cosBucket) {
        cosBucket.setAppId("0");
        this.cosBucketService.insert((Object)cosBucket);
        return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/update"})
    public RestResponse update(@Valid CosBucket cosBucket) {
        cosBucket.setUpdateTime(new Date());
        this.cosBucketService.updateSelective((Object)cosBucket);
        return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @PostMapping(value={"/delete"})
    public RestResponse delete(String id) {
        this.cosBucketService.updateDelete(id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/list"})
    public RestResponse list(HttpServletRequest request) {
        List lists = this.cosBucketService.selectList(JpaCriteria.builder().eq("appId", (Object)"0"));
        return RestResponse.success((Object)lists);
    }

    @GetMapping(value={"/getHeadUrlByCode"})
    public RestResponse getHeadUrlByCode(String code) {
        String headUrl = this.cosBucketService.getHeadUrlByCode(code);
        return RestResponse.success((String)headUrl);
    }

    @PostMapping(value={"/uploadFile2Cos"})
    public RestResponse upload(@RequestParam(value="file") MultipartFile file, String imageType) throws Exception {
        Shift.throwsIfInvalid((file == null ? 1 : 0) != 0, (String)"\u56fe\u7247\u4e0d\u5b58\u5728");
        Shift.throwsIfInvalid((file.getSize() > 0x1400000L ? 1 : 0) != 0, (String)"\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc720M\uff01");
        CosBucket cosBucket = this.cosBucketService.getCosBucketByAppId(this.getAppId());
        Shift.throwsIfNull((Object)((Object)cosBucket), (String)"cos\u672a\u6b63\u786e\u914d\u7f6e\uff0c\u65e0\u6cd5\u4e0a\u4f20\u56fe\u7247\uff0c\u8bf7\u8054\u7cfb\u7ef4\u62a4\u4eba\u5458\u6216\u5ba2\u670d");
        if (StringUtils.isBlank((CharSequence)imageType)) {
            imageType = "/default/";
        } else {
            if (!imageType.startsWith("/")) {
                imageType = "/" + imageType;
            }
            if (!imageType.endsWith("/")) {
                imageType = imageType + "/";
            }
        }
        String originalFileName = file.getOriginalFilename();
        int index = originalFileName.lastIndexOf(".");
        String subfix = originalFileName.substring(index);
        String pathName = imageType + GuidGenerator.generate() + subfix;
        COSClientUtil.uploadFile2Cos(cosBucket, file, pathName);
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("imageUrl", pathName);
        return RestResponse.success(json);
    }
}

