/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Page;
import com.wego168.base.domain.LevelConfig;
import com.wego168.base.domain.LevelType;
import com.wego168.base.service.LevelConfigService;
import com.wego168.base.service.LevelTypeService;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LevelConfigController
extends CrudController<LevelConfig> {
    @Autowired
    private LevelConfigService levelConfigService;
    @Autowired
    private LevelTypeService levelTypeService;
    @Autowired
    private AuthenticationUser authenticationUser;

    public CrudService<LevelConfig> getService() {
        return this.levelConfigService;
    }

    @PostMapping(value={"/api/admin/v1/level_config/add"})
    public RestResponse addLevelConfig(@RequestBody LevelConfig configParameter) {
        this.checkAddParams(configParameter);
        LevelConfig existLevelConfig = this.levelConfigService.selectByLevel(configParameter.getLevel(), configParameter.getType());
        if (existLevelConfig != null) {
            return RestResponse.error((String)"\u60a8\u8f93\u5165\u7684\u7b49\u7ea7\u5df2\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        LevelType levelType = this.levelTypeService.selectByType(configParameter.getType(), this.authenticationUser.getAppId());
        if (levelType == null) {
            return RestResponse.error((String)"\u60a8\u9009\u62e9\u7684\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        LevelConfig config = this.levelConfigService.create(configParameter.getType(), configParameter.getLevel(), configParameter.getExperienceAmount(), configParameter.getName(), configParameter.getIcon(), configParameter.getDescription(), levelType.getAppId());
        this.levelConfigService.insert((Object)config);
        return RestResponse.success((Object)((Object)config), (String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/level_config/delete"})
    public RestResponse deleteLevelConfig(String id, HttpServletRequest request) {
        id = request.getParameter("id");
        this.levelConfigService.deleteById(id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/level_config/update"})
    public RestResponse updateLevelConfig(@RequestBody LevelConfig configParameter) {
        this.checkUpdateParams(configParameter);
        this.levelConfigService.update(configParameter.getLevel(), configParameter.getExperienceAmount(), configParameter.getName(), configParameter.getIcon(), configParameter.getDescription(), configParameter.getId());
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/level_config/list"})
    public RestResponse selectList(Integer type, HttpServletRequest request) {
        Checker.checkUnsignedInteger((Integer)type, (String)"\u7b49\u7ea7\u7c7b\u578b");
        Page page = this.buildPage(request);
        List<LevelConfig> list = this.levelConfigService.selectList(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/level_config/item"})
    public RestResponse getLevelConfig(String id) {
        Checker.checkBlank((String)id, (String)"id");
        return super.get(id);
    }

    private void checkAddParams(LevelConfig configParameter) {
        Checker.checkPositiveInteger((Integer)configParameter.getType(), (String)"\u7b49\u7ea7\u7c7b\u578b");
        Checker.checkUnsignedInteger((Integer)configParameter.getLevel(), (String)"\u7b49\u7ea7");
        Checker.checkUnsignedInteger((Integer)configParameter.getExperienceAmount(), (String)"\u7ecf\u9a8c\u503c\u6570\u91cf");
        Checker.checkBlank((String)configParameter.getName(), (String)"\u540d\u79f0");
        Checker.checkBlank((String)configParameter.getDescription(), (String)"\u63cf\u8ff0");
    }

    private void checkUpdateParams(LevelConfig configParameter) {
        Checker.checkUnsignedInteger((Integer)configParameter.getLevel(), (String)"\u7b49\u7ea7");
        Checker.checkUnsignedInteger((Integer)configParameter.getExperienceAmount(), (String)"\u7ecf\u9a8c\u503c\u6570\u91cf");
        Checker.checkBlank((String)configParameter.getName(), (String)"\u540d\u79f0");
        Checker.checkBlank((String)configParameter.getDescription(), (String)"\u63cf\u8ff0");
        Checker.checkBlank((String)configParameter.getId(), (String)"id");
    }
}

