/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Page;
import com.wego168.base.domain.LevelExperienceSource;
import com.wego168.base.domain.LevelType;
import com.wego168.base.service.LevelExperienceSourceService;
import com.wego168.base.service.LevelTypeService;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.util.RequestUtil;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="AdminLevelExperienceSourceController")
public class LevelExperienceSourceController
extends CrudController<LevelExperienceSource> {
    @Autowired
    private LevelExperienceSourceService levelExperienceSourceService;
    @Autowired
    private LevelTypeService levelTypeService;
    @Autowired
    private AuthenticationUser authenticationUser;

    public CrudService<LevelExperienceSource> getService() {
        return this.levelExperienceSourceService;
    }

    @PostMapping(value={"/api/admin/v1/level_experience_source/add"})
    public RestResponse addLevelExperienceSource(@RequestBody LevelExperienceSource levelExperienceSource) {
        this.checkAddParams(levelExperienceSource);
        int type = levelExperienceSource.getType();
        String appId = this.authenticationUser.getAppId();
        LevelType levelType = this.levelTypeService.selectByType(type, appId);
        if (levelType == null) {
            return RestResponse.error((String)"\u8be5\u7b49\u7ea7\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        String code = levelExperienceSource.getCode();
        LevelExperienceSource existSource = this.levelExperienceSourceService.selectByCode(type, code, appId);
        if (existSource != null) {
            return RestResponse.error((String)"\u60a8\u8f93\u5165\u7684\u7f16\u7801\u5df2\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        this.levelExperienceSourceService.insert((Object)levelExperienceSource);
        return RestResponse.success((Object)((Object)levelExperienceSource), (String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/level_experience_source/delete"})
    public RestResponse deleteLevelExperienceSource(String id, HttpServletRequest request) {
        id = request.getParameter("id");
        this.levelExperienceSourceService.deleteById(id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/level_experience_source/update"})
    public RestResponse updateLevelExperienceSource(@RequestBody LevelExperienceSource levelExperienceSourceParameter) {
        this.checkUpdateParams(levelExperienceSourceParameter);
        this.levelExperienceSourceService.update(levelExperienceSourceParameter.getAmount(), levelExperienceSourceParameter.getMaxPerDay(), levelExperienceSourceParameter.getDescription(), levelExperienceSourceParameter.getName(), levelExperienceSourceParameter.getNote(), levelExperienceSourceParameter.getId());
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/level_experience_source/list"})
    public RestResponse selectList(Integer type, HttpServletRequest request) {
        type = RequestUtil.getIntegerParam((HttpServletRequest)request, (String)"type");
        Checker.checkUnsignedInteger((Integer)type, (String)"\u7b49\u7ea7\u7c7b\u578b");
        Page page = this.buildPage(request);
        List<LevelExperienceSource> list = this.levelExperienceSourceService.selectList(type, this.authenticationUser.getAppId(), page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/level_experience_source/item"})
    public RestResponse getLevelExperienceSource(String id) {
        Checker.checkBlank((String)id, (String)"id");
        return super.get(id);
    }

    private void checkAddParams(LevelExperienceSource levelExperienceSourceParameter) {
        Checker.checkPositiveInteger((Integer)levelExperienceSourceParameter.getAmount(), (String)"\u7ecf\u9a8c\u503c\u6570\u91cf");
        Checker.checkUnsignedInteger((Integer)levelExperienceSourceParameter.getType(), (String)"\u7b49\u7ea7\u7c7b\u578b");
        Checker.checkUnsignedInteger((Integer)levelExperienceSourceParameter.getMaxPerDay(), (String)"\u6bcf\u65e5\u4e0a\u9650");
        Checker.checkBlank((String)levelExperienceSourceParameter.getName(), (String)"\u540d\u79f0");
        Checker.checkBlank((String)levelExperienceSourceParameter.getCode(), (String)"\u7f16\u7801");
    }

    private void checkUpdateParams(LevelExperienceSource levelExperienceSourceParameter) {
        Checker.checkPositiveInteger((Integer)levelExperienceSourceParameter.getAmount(), (String)"\u7ecf\u9a8c\u503c\u6570\u91cf");
        Checker.checkUnsignedInteger((Integer)levelExperienceSourceParameter.getMaxPerDay(), (String)"\u6bcf\u65e5\u4e0a\u9650");
        Checker.checkBlank((String)levelExperienceSourceParameter.getName(), (String)"\u540d\u79f0");
        Checker.checkBlank((String)levelExperienceSourceParameter.getId(), (String)"id");
    }
}

