/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.LevelType;
import com.wego168.base.service.LevelTypeService;
import com.wego168.service.CrudService;
import com.wego168.util.Checker;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LevelTypeController
extends CrudController<LevelType> {
    @Autowired
    private LevelTypeService levelTypeService;
    @Autowired
    private AuthenticationUser authenticationUser;

    public CrudService<LevelType> getService() {
        return this.levelTypeService;
    }

    @PostMapping(value={"/api/admin/v1/level_type/add"})
    public RestResponse addLevelType(@RequestBody LevelType levelTypeParameter) {
        this.checkAddParams(levelTypeParameter);
        Integer type = levelTypeParameter.getType();
        LevelType existLevelType = this.levelTypeService.selectByType(type, this.authenticationUser.getAppId());
        if (existLevelType != null) {
            return RestResponse.error((String)"\u60a8\u8f93\u5165\u7684\u7c7b\u578b\u5df2\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        LevelType levelType = this.levelTypeService.create(type, levelTypeParameter.getName(), levelTypeParameter.getDescription(), levelTypeParameter.getIcon());
        this.levelTypeService.insert((Object)levelType);
        return RestResponse.success((Object)((Object)levelType), (String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/level_type/update"})
    public RestResponse updateLevelType(@RequestBody LevelType levelTypeParameter) {
        this.checkUpdateParams(levelTypeParameter);
        this.levelTypeService.update(levelTypeParameter.getName(), levelTypeParameter.getDescription(), levelTypeParameter.getIcon(), levelTypeParameter.getId());
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/api/admin/v1/level_type/list"})
    public RestResponse selectList(HttpServletRequest request) {
        Page page = this.buildPage(request);
        List list = this.levelTypeService.selectList((JpaCriteria)page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/level_type/item"})
    public RestResponse getLevelType(String id) {
        Checker.checkBlank((String)id, (String)"id");
        return super.get(id);
    }

    private void checkAddParams(LevelType levelType) {
        Checker.checkPositiveInteger((Integer)levelType.getType(), (String)"\u7b49\u7ea7\u7c7b\u578b");
        Checker.checkBlank((String)levelType.getName(), (String)"\u540d\u79f0");
        Checker.checkBlank((String)levelType.getDescription(), (String)"\u63cf\u8ff0");
    }

    private void checkUpdateParams(LevelType levelType) {
        Checker.checkBlank((String)levelType.getId(), (String)"id");
        Checker.checkBlank((String)levelType.getDescription(), (String)"\u63cf\u8ff0");
        Checker.checkBlank((String)levelType.getName(), (String)"\u540d\u79f0");
    }
}

