/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.JpaCriteria;
import com.wego168.base.domain.PartakeSense;
import com.wego168.base.domain.ReviewSummary;
import com.wego168.base.service.PartakeSenseService;
import com.wego168.base.service.ReviewSummaryService;
import com.wego168.base.service.ShortSentenceService;
import com.wego168.domain.CosAccess;
import com.wego168.service.CrudService;
import com.wego168.util.EnvironmentUtil;
import com.wego168.util.Shift;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminReviewSummaryController")
@RequestMapping(value={"/api/admin/v1/reviewSummary"})
public class ReviewSummaryController
extends CrudController<ReviewSummary> {
    @Autowired
    private ReviewSummaryService reviewSummaryService;
    @Autowired
    private ShortSentenceService shortSentenceService;
    @Autowired
    private Environment env;
    @Autowired
    private PartakeSenseService partakeSenseService;

    public CrudService<ReviewSummary> getService() {
        return this.reviewSummaryService;
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5355\u4e2a\u56de\u987e")
    @GetMapping(value={"/get"})
    public RestResponse get(String id) {
        ReviewSummary vo = this.reviewSummaryService.selectReviewSummaryById(id);
        List shortSentenceList = this.shortSentenceService.selectList(JpaCriteria.builder().eq("sourceId", (Object)vo.getSourceId()).orderBy("sort"));
        vo.setShortSentenceList(shortSentenceList);
        return RestResponse.success((Object)((Object)vo));
    }

    @ApiOperation(value="\u6839\u636esourceId\u5206\u9875\u67e5\u8be2\u56de\u987e\u5c0f\u7ed3\u5217\u8868")
    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request) {
        return super.page(request);
    }

    @ApiOperation(value="\u6dfb\u52a0\u56de\u987e\u5c0f\u7ed3")
    @PostMapping(value={"/add"})
    public RestResponse insert(@Valid @RequestBody ReviewSummary vo, HttpServletRequest request) {
        ReviewSummary reviewSummary = (ReviewSummary)((Object)this.reviewSummaryService.select(JpaCriteria.builder().eq("sourceId", (Object)vo.getSourceId()).eq("isDeleted", (Object)false)));
        Shift.throwsIfInvalid((reviewSummary != null ? 1 : 0) != 0, (String)"\u65e0\u6cd5\u6dfb\u52a0\u5c0f\u7ed3");
        String imgPath = request.getServletContext().getRealPath("/attachment/tmp/");
        CosAccess access = EnvironmentUtil.createCosAccess((Environment)this.env);
        if (access == null) {
            return RestResponse.error((String)"cos\u672a\u6b63\u786e\u914d\u7f6e\uff0c\u65e0\u6cd5\u4e0a\u4f20\u56fe\u7247\uff0c\u8bf7\u8054\u7cfb\u7ef4\u62a4\u4eba\u5458\u6216\u5ba2\u670d");
        }
        this.reviewSummaryService.insertReviewSummary(vo, imgPath, access);
        return RestResponse.success((Object)((Object)vo));
    }

    @ApiOperation(value="\u66f4\u65b0\u56de\u987e\u5c0f\u7ed3")
    @PostMapping(value={"/update"})
    public RestResponse update(@RequestBody ReviewSummary vo) {
        ReviewSummary oldReviewSummary = (ReviewSummary)((Object)this.reviewSummaryService.selectById(vo.getId()));
        ReviewSummary newReviewSummary = this.reviewSummaryService.updateReviewSummary(oldReviewSummary, vo);
        return RestResponse.success((Object)((Object)newReviewSummary));
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u56de\u987e\u5c0f\u7ed3")
    @PostMapping(value={"/delete"})
    public RestResponse delete(String id) {
        ReviewSummary reviewSummary = (ReviewSummary)((Object)this.reviewSummaryService.selectById(id));
        String sourceId = reviewSummary.getSourceId();
        List shortSentences = this.shortSentenceService.selectList(JpaCriteria.builder().eq("sourceId", (Object)sourceId));
        for (Object shortSentence : shortSentences) {
            this.shortSentenceService.updateDelete(shortSentence.getId());
        }
        List partakeSenses = this.partakeSenseService.selectList(JpaCriteria.builder().eq("sourceId", (Object)sourceId));
        for (PartakeSense partakeSense : partakeSenses) {
            this.partakeSenseService.deleteById(partakeSense.getId());
        }
        int row = this.reviewSummaryService.updateDelete(id);
        return this.responseByRows(row);
    }
}

