/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Page;
import com.wego168.base.domain.SensitiveWord;
import com.wego168.base.service.SensitiveWordService;
import com.wego168.util.Checker;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.validation.constraints.UnsignedInteger;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class SensitiveWordController
extends SimpleController {
    @Autowired
    private SensitiveWordService service;

    @GetMapping(value={"/api/admin/v1/sensitive-word/page"})
    public RestResponse selectPage(HttpServletRequest request, @NotBlankAndLength(min=1, max=32, message="\u7c7b\u578b\u975e\u6cd5") String type, String orderBy) {
        String appId = super.getAppId();
        Page page = super.buildPage(request);
        page.setList(this.service.selectPage(appId, type, orderBy, page));
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/admin/v1/sensitive-word/get"})
    public RestResponse get(@NotBlankAndLength String id) {
        return RestResponse.success((Object)this.service.selectById(id));
    }

    @PostMapping(value={"/api/admin/v1/sensitive-word/insert"})
    public RestResponse insert(@NotBlankAndLength(min=1, max=8, message="\u654f\u611f\u8bcd\u957f\u5ea6\u5fc5\u987b\u57281~8\u5b57\u7b26\u4e4b\u95f4") String word, @NotBlankAndLength(min=1, max=32, message="\u7c7b\u578b\u975e\u6cd5") String type, @RequestParam(name="sortNumber", required=false) @UnsignedInteger(message="\u5e8f\u53f7\u975e\u6cd5") String sortNumberString, String groupId) {
        int sortNumber = StringUtil.isBlank((String)sortNumberString) ? 0 : Integer.parseInt(sortNumberString);
        String appId = super.getAppId();
        Checker.checkCondition((this.service.exist(appId, type, word) != null ? 1 : 0) != 0, (String)"\u8be5\u654f\u611f\u8bcd\u5df2\u5b58\u5728");
        SensitiveWord sensitiveWord = new SensitiveWord();
        sensitiveWord.setId(SequenceUtil.createUuid());
        sensitiveWord.setAppId(appId);
        sensitiveWord.setWord(word);
        if (StringUtil.isBlank((String)groupId)) {
            groupId = "default";
        }
        sensitiveWord.setType(type);
        sensitiveWord.setGroupId(groupId);
        sensitiveWord.setSortNumber(sortNumber);
        sensitiveWord.setCreateTime(new Date());
        this.service.insert(sensitiveWord);
        return RestResponse.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/sensitive-word/delete"})
    public RestResponse add(@NotBlankAndLength String id) {
        this.service.deleteById(id);
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/api/admin/v1/sensitive-word/update"})
    public RestResponse add(@NotBlankAndLength String id, @NotBlankAndLength(min=1, max=32, message="\u7c7b\u578b\u975e\u6cd5") String type, @RequestParam(name="sortNumber", required=false) @UnsignedInteger(message="\u5e8f\u53f7\u975e\u6cd5") String sortNumberString, String word, String groupId) {
        String appId = super.getAppId();
        SensitiveWord existSensitiveWord = this.service.exist(appId, type, word);
        Checker.checkCondition((existSensitiveWord != null && !StringUtil.equals((String)id, (String)existSensitiveWord.getId()) ? 1 : 0) != 0, (String)"\u8be5\u654f\u611f\u8bcd\u5df2\u5b58\u5728");
        int sortNumber = StringUtil.isBlank((String)sortNumberString) ? 0 : Integer.parseInt(sortNumberString);
        SensitiveWord param = new SensitiveWord();
        param.setId(id);
        param.setWord(word);
        param.setType(type);
        if (StringUtil.isBlank((String)groupId)) {
            groupId = "default";
        }
        param.setGroupId(groupId);
        param.setSortNumber(sortNumber);
        this.service.updateSelective(param);
        return RestResponse.success((String)"\u4fee\u6539\u6210\u529f");
    }
}

