/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.Page;
import com.wego168.base.domain.SingleContent;
import com.wego168.base.domain.SingleContentTag;
import com.wego168.base.service.SingleContentService;
import com.wego168.base.service.SingleContentTagService;
import com.wego168.service.CrudService;
import com.wego168.util.SequenceUtil;
import com.wego168.util.StringUtil;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController(value="AdminSingleContentController")
public class SingleContentController
extends CrudController<SingleContent> {
    @Autowired
    private SingleContentService singleContentService;
    @Autowired
    private SingleContentTagService singleContentTagService;

    public CrudService<SingleContent> getService() {
        return this.singleContentService;
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5355\u4e2a\u5355\u56fe\u6587")
    @GetMapping(value={"/api/admin/v1/singleContent/get"})
    public RestResponse get2(@NotBlankAndLength String id) {
        SingleContent singleContent = this.singleContentService.getById(id);
        return RestResponse.success((Object)singleContent);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5355\u56fe\u6587")
    @GetMapping(value={"/api/admin/v1/singleContent/page"})
    public RestResponse page(String categoryId, String title, Integer status, String orderBy, HttpServletRequest request) {
        Page page = this.buildPage(request);
        List<SingleContent> lists = this.singleContentService.selectSingleContentPageByAdmin(orderBy, page);
        page.setList(lists);
        return RestResponse.success((Object)page);
    }

    @ApiOperation(value="\u6dfb\u52a0\u5355\u56fe\u6587")
    @PostMapping(value={"/api/admin/v1/singleContent/insert"})
    public RestResponse insert2(@Valid @RequestBody SingleContent singleContent) {
        this.singleContentService.inserts(singleContent);
        if (null != singleContent.getTagId() && singleContent.getTagId().size() > 0) {
            this.singleContentTagService.insertBatch(this.createSingleContentTag(singleContent));
        }
        return RestResponse.success((Object)singleContent, (String)"");
    }

    @ApiOperation(value="\u4fee\u6539\u5355\u56fe\u6587\u663e\u793a\u72b6\u6001")
    @PostMapping(value={"/api/admin/v1/singleContent/changeDisplay"})
    public RestResponse hide(String id, Boolean isDisplay) {
        SingleContent singleContent = this.singleContentService.getById(id);
        singleContent.setIsDisplay(isDisplay);
        this.singleContentService.updateSelective(singleContent);
        return RestResponse.success((String)"");
    }

    @ApiOperation(value="\u66f4\u65b0\u5355\u56fe\u6587")
    @PostMapping(value={"/update"})
    public RestResponse update2(@Valid @RequestBody SingleContent singleContent) {
        this.singleContentService.updates(singleContent);
        if (null != singleContent.getTagId() && singleContent.getTagId().size() > 0) {
            this.singleContentTagService.updateBatch(this.createSingleContentTag(singleContent));
        }
        return RestResponse.success((String)"");
    }

    @ApiOperation(value="\u6839\u636eID\u5220\u9664\u5355\u56fe\u6587")
    @PostMapping(value={"/api/admin/v1/singleContent/delete"})
    public RestResponse delete2(String id) {
        int row = this.singleContentService.updateDelete(id);
        return this.responseByRows(row);
    }

    @PostMapping(value={"/api/admin/v1/singleContent/deleteBatch"})
    public RestResponse deleteBatch(@RequestBody List<String> ids) {
        int row = this.singleContentService.deleteBatch(ids);
        return RestResponse.success((Object)row);
    }

    private List<SingleContentTag> createSingleContentTag(SingleContent singleContent) {
        ArrayList<SingleContentTag> singleContentTagList = new ArrayList<SingleContentTag>();
        List<String> tagIds = singleContent.getTagId();
        for (String id : tagIds) {
            SingleContentTag singleContentTag = new SingleContentTag();
            if (StringUtil.isBlank((String)singleContent.getId())) {
                singleContentTag.setId(SequenceUtil.createUuid());
            }
            singleContentTag.setSingleContentId(singleContent.getId());
            singleContentTag.setTagId(id);
            singleContentTagList.add(singleContentTag);
        }
        return singleContentTagList;
    }
}

