/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Tag;
import com.wego168.base.interceptor.ApiLog;
import com.wego168.base.service.TagService;
import com.wego168.service.CrudService;
import com.wego168.util.Shift;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="adminTagController")
@RequestMapping(value={"/api/admin/v1/tag"})
public class TagController
extends CrudController<Tag> {
    @Autowired
    private TagService tagService;
    @Autowired
    protected AuthenticationUser authenticationUser;

    public CrudService<Tag> getService() {
        return this.tagService;
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5355\u4e2a\u6807\u7b7e")
    @GetMapping(value={"/get"})
    public RestResponse get(String id) {
        return super.get(id);
    }

    @ApiOperation(value="\u6839\u636ecode\u67e5\u8be2\u5355\u4e2a\u6807\u7b7e")
    @GetMapping(value={"/code"})
    public RestResponse getByCode(String code) {
        Tag tag = this.tagService.selectByCode(code);
        return RestResponse.success((Object)tag);
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u6807\u7b7e\u5217\u8868")
    @GetMapping(value={"/list"})
    public RestResponse list(HttpServletRequest request) {
        List list = this.tagService.selectList(JpaCriteria.builder());
        return RestResponse.success((Object)list);
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u6807\u7b7e\u5217\u8868")
    @GetMapping(value={"/listByType"})
    public RestResponse listByType(int type) {
        List list = this.tagService.selectList(JpaCriteria.builder().eq("type", (Object)type));
        return RestResponse.success((Object)list);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6807\u7b7e")
    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.eq("type");
        page.orderBy("seqNum");
        List list = this.tagService.selectPage(page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    @ApiLog(value="\u6dfb\u52a0\u6807\u7b7e")
    @PostMapping(value={"/insert"})
    public RestResponse insert(@Valid @RequestBody Tag vo) {
        this.checkParam(vo);
        return super.insert((Object)vo);
    }

    @ApiLog(value="\u66f4\u65b0\u6807\u7b7e")
    @PostMapping(value={"/update"})
    public RestResponse update(@Valid @RequestBody Tag vo) {
        this.checkParam(vo);
        return super.update((Object)vo);
    }

    @ApiLog(value="\u6839\u636eID\u5220\u9664\u6807\u7b7e")
    @PostMapping(value={"/delete"})
    public RestResponse delete(String id) {
        int row = this.tagService.updateDelete(id);
        return this.responseByRows(row);
    }

    private void checkParam(Tag vo) {
        Shift.throwsIfBlank((String)vo.getName(), (String)"\u6807\u7b7e\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Shift.throwsIfNull((Object)vo.getType(), (String)"\u6807\u7b7e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        vo.setAppId(this.getAppId());
        vo.setCode(this.tagService.getByCode(vo));
        Shift.throwsIfInvalid((boolean)this.tagService.isPresent(vo.getName(), vo.getType()), (String)"\u6807\u7b7e\u540d\u4e0d\u80fd\u91cd\u590d");
    }
}

