/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.controller;

import com.wego168.base.domain.TextMaterial;
import com.wego168.base.service.TextMaterialService;
import com.wego168.exception.WegoException;
import com.wego168.util.Checker;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController(value="adminTextMaterialController")
public class TextMaterialController
extends SimpleController {
    @Autowired
    private TextMaterialService service;

    @PostMapping(value={"/api/admin/v1/text-material/{code}/update"})
    public RestResponse updateMaterial(@PathVariable String code, @NotBlankAndLength(min=1, max=128, message="\u6807\u9898\u7684\u957f\u5ea6\u5fc5\u987b\u57281~128\u5b57\u7b26\u4e4b\u95f4") String title, String content) {
        try {
            Checker.checkBlank((String)content, (String)"\u5185\u5bb9");
            String appId = this.getAppId();
            TextMaterial material = this.service.selectByCode(code, appId);
            if (material == null) {
                this.service.insert(code, content, title, appId);
            } else {
                this.service.update(content, title, material.getId());
            }
            return RestResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
        }
        catch (WegoException e) {
            return RestResponse.exception((WegoException)e);
        }
    }

    @GetMapping(value={"/api/admin/v1/text-material/{code}/get"})
    public RestResponse getMaterial(@PathVariable String code) {
        String appId = this.getAppId();
        return RestResponse.success((Object)((Object)this.service.selectByCode(code, appId)), (String)"ok");
    }
}

