/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum AppStatusEnum {
    NEW(0, "\u5f85\u5ba1\u6838"),
    NORMAL(1, "\u4f7f\u7528\u4e2d"),
    FAIL(6, "\u5ba1\u6279\u4e0d\u901a\u8fc7"),
    EXPIRE(7, "\u5df2\u8fc7\u671f"),
    AUTHOR_END(8, "\u6388\u6743\u7ed3\u675f"),
    END(9, "\u5df2\u505c\u6b62");

    private int value;
    private String description;
    private static final Map<Integer, String> valueMapping;
    private static final Map<Integer, AppStatusEnum> objectMapping;

    private AppStatusEnum(int value, String description) {
        this.value = value;
        this.description = description;
    }

    public int value() {
        return this.value;
    }

    public String description() {
        return this.description;
    }

    public static boolean isValid(int value) {
        return valueMapping.containsKey(value);
    }

    public static AppStatusEnum get(Integer key) {
        return objectMapping.get(key);
    }

    public static String getDesc(Integer key) {
        if (AppStatusEnum.isValid(key)) {
            return valueMapping.get(key);
        }
        return "";
    }

    static {
        valueMapping = new ConcurrentHashMap<Integer, String>();
        objectMapping = new HashMap<Integer, AppStatusEnum>();
        for (AppStatusEnum item : AppStatusEnum.values()) {
            valueMapping.put(item.value(), item.description());
            objectMapping.put(item.value(), item);
        }
    }
}

