/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.enums;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum OrderStatusEnum {
    REFUSE(-3, "\u62d2\u7edd\u9000\u6b3e"),
    REFUND(-2, "\u5df2\u9000\u6b3e"),
    CANCEL(-1, "\u5df2\u53d6\u6d88"),
    PAY(0, "\u5f85\u652f\u4ed8"),
    UN_DELIVER(1, "\u5f85\u53d1\u8d27"),
    DELIVER(2, "\u5df2\u53d1\u8d27"),
    RECEIVED(3, "\u5df2\u6536\u8d27"),
    RETURN_ING(4, "\u9000\u8d27\u4e2d"),
    EXCHANGE_ING(5, "\u6362\u8d27\u4e2d"),
    REFUND_ING(6, "\u9000\u6b3e\u4e2d"),
    SOME_DELIVER(7, "\u90e8\u5206\u53d1\u8d27"),
    FINISH(10, "\u5df2\u5b8c\u6210");

    private int id;
    private String desc;
    private static final Map<Integer, String> idDescMapping;

    private OrderStatusEnum(int id, String desc) {
        this.id = id;
        this.desc = desc;
    }

    public int id() {
        return this.id;
    }

    public String desc() {
        return this.desc;
    }

    public static String getDesc(Integer key) {
        if (key != null && idDescMapping.containsKey(key)) {
            return idDescMapping.get(key);
        }
        return "";
    }

    static {
        idDescMapping = new ConcurrentHashMap<Integer, String>();
        for (OrderStatusEnum item : OrderStatusEnum.values()) {
            idDescMapping.put(item.id(), item.desc());
        }
    }
}

