/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.enums;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum StorageType {
    ALIYUN("AliyunOss", "\u963f\u91cc\u4e91"),
    TENCENT_CLOUD("TencentCloudCos", "\u817e\u8baf\u4e91"),
    DEFAULT("TencentCloudCos", "\u9ed8\u8ba4");

    private String value;
    private String description;
    private static final Map<String, String> valueMapping;
    private static final Map<String, StorageType> objectMapping;

    private StorageType(String value, String description) {
        this.value = value;
        this.description = description;
    }

    public String value() {
        return this.value;
    }

    public String description() {
        return this.description;
    }

    public static boolean isValid(String value) {
        return valueMapping.containsKey(value);
    }

    public static StorageType get(String key) {
        return objectMapping.get(key);
    }

    public static void main(String[] args) {
        for (StorageType e : StorageType.values()) {
            System.out.print(e.value + "=" + e.description + "\uff0c");
        }
    }

    static {
        valueMapping = new ConcurrentHashMap<String, String>();
        objectMapping = new HashMap<String, StorageType>();
        for (StorageType item : StorageType.values()) {
            valueMapping.put(item.value(), item.description());
            objectMapping.put(item.value(), item);
        }
    }
}

