/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.external;

import com.alibaba.fastjson.JSONObject;
import com.wego168.base.service.AppService;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.util.MD5Util;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ExternalController<T>
extends CrudController<T> {
    @Autowired
    protected SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private AppService appService;

    protected String getAppKey() {
        return this.getAppId();
    }

    protected String getAppSecret() {
        String appId = this.getAppId();
        String key = this.simpleRedisTemplate.getString("ExternalAppSecret" + appId);
        if (StringUtils.isBlank((CharSequence)key)) {
            String code = this.appService.getCodeByAppId(appId);
            key = MD5Util.sign((String)appId, (String)code).toLowerCase();
            this.simpleRedisTemplate.setString("ExternalAppSecret" + appId, key);
        }
        return key;
    }

    protected RestResponse auth(HttpServletRequest request) {
        String timestamp = request.getHeader("X-Yx-Timestamp");
        String nonce = request.getHeader("X-Yx-Nonce");
        String appId = request.getHeader("Application-Key");
        String sign = request.getHeader("X-Yx-Signature");
        if (!StringUtils.equals((CharSequence)appId, (CharSequence)this.getAppKey())) {
            return RestResponse.error((String)"Application-Key\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u6b63\u786e\u7684Application-Key\u8fdb\u884c\u8c03\u7528");
        }
        String mysign = ExternalController.sign(timestamp, nonce, appId, this.getAppSecret());
        if (!StringUtils.equals((CharSequence)sign, (CharSequence)mysign)) {
            return RestResponse.error((String)"\u8c03\u7528\u5931\u8d25\uff1a\u7b7e\u540d\u9519\u8bef");
        }
        Long timestampL = Long.valueOf(timestamp);
        if (System.currentTimeMillis() / 1000L - timestampL > 360L) {
            return RestResponse.error((String)"\u8c03\u7528\u5931\u8d25\uff1a\u8bf7\u6c42\u8fc7\u671f\uff0c\u8bf7\u66f4\u6362\u65f6\u95f4\u6233\u91cd\u65b0\u8bf7\u6c42");
        }
        return null;
    }

    protected RestResponse verify(JSONObject json) {
        String key = this.getAppKey();
        if (!json.containsKey((Object)"msgId")) {
            return RestResponse.error((String)"\u8c03\u7528\u5931\u8d25\uff1a\u6d88\u606f\u683c\u5f0f\u9519\u8bef\uff0c\u6d88\u606f\u4f53\u5fc5\u987b\u5305\u542bmsgId \u5982{\"msgId\":\"xxxxxx\",xxx}");
        }
        String msgId = json.getString("msgId");
        if (StringUtils.isBlank((CharSequence)msgId)) {
            return RestResponse.error((String)"\u8c03\u7528\u5931\u8d25\uff1a\u6d88\u606fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String id = this.simpleRedisTemplate.getString(key + msgId);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return RestResponse.error((String)"\u8c03\u7528\u5931\u8d25\uff1a\u6d88\u606fID\u91cd\u590d\u8bf7\u6c42\uff0c\u8bf7\u66f4\u6362msgId\u540e\u91cd\u8bd5");
        }
        this.simpleRedisTemplate.set(key + msgId, (Object)msgId, 360L);
        return null;
    }

    protected static String sign(String timestamp, String nonce, String appKey, String appSecret) {
        TreeMap<String, String> signMap = new TreeMap<String, String>();
        signMap.put("X-Yx-Timestamp", timestamp);
        signMap.put("X-Yx-Nonce", nonce);
        signMap.put("Application-Key", appKey);
        signMap.put("Application-Secret", appSecret);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : signMap.entrySet()) {
            sb.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("&");
        }
        sb.setLength(sb.length() - 1);
        return HmacUtils.hmacSha256Hex((String)appSecret, (String)sb.toString());
    }
}

