/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.filter;

import com.wego168.domain.BaseDomain;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.util.EnvironmentUtil;
import com.wego168.web.util.ServletContextHolder;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class AppContextFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(AppContextFilter.class);
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;
    @Autowired
    private Environment env;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)resp;
        HttpServletRequest request = (HttpServletRequest)req;
        String contextPath = request.getContextPath();
        if (StringUtils.isBlank((CharSequence)contextPath)) {
            String context;
            String uri = request.getRequestURI();
            String regex = "(" + contextPath + ")(/.*?)(/.*)";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(uri);
            if (m.find() && StringUtils.isNotBlank((CharSequence)(context = m.group(2)))) {
                String code = context.substring(1);
                String forward = m.group(3);
                try {
                    forward = URLDecoder.decode(forward, "UTF-8");
                }
                catch (Exception e) {
                    this.logger.error("forward urldecode", (Throwable)e);
                }
                BaseDomain app = (BaseDomain)this.simpleRedisTemplate.get(code, BaseDomain.class);
                if (app != null) {
                    String appId = ServletContextHolder.getAppId();
                    String nowAppId = app.getAppId();
                    if (StringUtils.isNotBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)nowAppId) && !StringUtils.equals((CharSequence)appId, (CharSequence)nowAppId)) {
                        ServletContextHolder.removeOpenId();
                        ServletContextHolder.removeMemberId();
                    }
                    ServletContextHolder.setAppId((String)nowAppId);
                    request.getRequestDispatcher(forward).forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                if (StringUtils.equals((CharSequence)context, (CharSequence)EnvironmentUtil.getContext((Environment)this.env))) {
                    request.getRequestDispatcher(forward).forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        } else {
            String code;
            BaseDomain app;
            String context;
            String uri = request.getRequestURI();
            String regex = "(" + contextPath + ")(/.*?)(/.*)";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(uri);
            if (m.find() && StringUtils.isNotBlank((CharSequence)(context = m.group(2)))) {
                String code2 = context.substring(1);
                String forward = m.group(3);
                try {
                    forward = URLDecoder.decode(forward, "UTF-8");
                }
                catch (Exception e) {
                    this.logger.error("forward urldecode", (Throwable)e);
                }
                BaseDomain app2 = (BaseDomain)this.simpleRedisTemplate.get(code2, BaseDomain.class);
                if (app2 != null) {
                    String appId = ServletContextHolder.getAppId();
                    String nowAppId = app2.getAppId();
                    if (StringUtils.isNotBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)nowAppId) && !StringUtils.equals((CharSequence)appId, (CharSequence)nowAppId)) {
                        ServletContextHolder.removeOpenId();
                        ServletContextHolder.removeMemberId();
                    }
                    ServletContextHolder.setAppId((String)nowAppId);
                    request.getRequestDispatcher(forward).forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
            }
            if ((app = (BaseDomain)this.simpleRedisTemplate.get(code = contextPath.substring(1), BaseDomain.class)) != null) {
                String appId = ServletContextHolder.getAppId();
                String nowAppId = app.getAppId();
                if (StringUtils.isNotBlank((CharSequence)appId) && StringUtils.isNotBlank((CharSequence)nowAppId) && !StringUtils.equals((CharSequence)appId, (CharSequence)nowAppId)) {
                    ServletContextHolder.removeOpenId();
                    ServletContextHolder.removeMemberId();
                }
                ServletContextHolder.setAppId((String)nowAppId);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

