/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.interceptor;

import com.google.common.eventbus.AsyncEventBus;
import com.wego168.base.domain.AppApiLogger;
import com.wego168.base.enums.AppApiLoggerStatusEnum;
import com.wego168.base.interceptor.ApiLog;
import com.wego168.base.interceptor.ApiLogCallback;
import com.wego168.base.listener.AppApiLoggerListener;
import com.wego168.util.InterfaceDispatcher;
import com.wego168.util.RequestUtil;
import com.wego168.util.SimpleJackson;
import com.wego168.util.StringUtil;
import com.wego168.web.AuthenticationUser;
import com.wego168.web.util.GuidGenerator;
import com.wego168.web.util.ServletContextHolder;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ApiLogInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ApiLogInterceptor.class);
    private static final String CONTENT_TYPE = "application/json";
    private static final ThreadLocal<AppApiLogger> THREAD_LOCAL = new ThreadLocal();
    private static final Executor EXECUTOR = Executors.newFixedThreadPool(4);
    @Autowired
    private AppApiLoggerListener appApiLoggerListener;
    @Autowired
    private AuthenticationUser auth;
    @Autowired
    private Environment env;

    public String getAppId() {
        String devAppId = this.env.getProperty("env.dev.appid");
        if (StringUtil.isNotBlank((String)devAppId)) {
            return devAppId;
        }
        return this.auth.getAppId();
    }

    @Pointcut(value="execution(public * com.wego168..*Controller.*(..))")
    public void apiPoint() {
    }

    private ApiLog getApiLog(JoinPoint jp) {
        MethodSignature methodSignature = (MethodSignature)jp.getSignature();
        Method method = methodSignature.getMethod();
        ApiLog apiLog = method.getAnnotation(ApiLog.class);
        return apiLog;
    }

    @Before(value="apiPoint()")
    public void before(JoinPoint jp) {
        AppApiLogger appApiLogger = new AppApiLogger();
        appApiLogger.setStartTime(System.currentTimeMillis());
        appApiLogger.setVisitor(this.auth.getUser());
        THREAD_LOCAL.set(appApiLogger);
    }

    @AfterReturning(value="apiPoint()")
    public void afterReturning(JoinPoint jp) {
        AppApiLogger appApiLogger = THREAD_LOCAL.get();
        if (appApiLogger != null) {
            appApiLogger.setStatus(AppApiLoggerStatusEnum.SUCCESS.name());
            this.doAfter(jp, appApiLogger);
        }
    }

    @AfterThrowing(value="apiPoint()", throwing="e")
    public void afterThorwing(JoinPoint jp, Throwable e) {
        AppApiLogger appApiLogger = THREAD_LOCAL.get();
        if (appApiLogger != null) {
            appApiLogger.setStatus(AppApiLoggerStatusEnum.FAILURE.name());
            appApiLogger.setResponseBody(e.toString());
            this.doAfter(jp, appApiLogger);
        }
    }

    public void doAfter(JoinPoint jp, AppApiLogger appApiLogger) {
        try {
            HttpServletRequest request = ServletContextHolder.getRequest();
            String requestBody = null;
            String paramRequired = this.env.getProperty("apiLog.request.param.required");
            if (!StringUtils.equalsIgnoreCase((CharSequence)"false", (CharSequence)paramRequired)) {
                requestBody = this.getBodyString(request);
            }
            ApiLog apiLog = this.getApiLog(jp);
            long times = System.currentTimeMillis() - appApiLogger.getStartTime();
            appApiLogger.setAppId(this.getAppId());
            appApiLogger.setTimes(times);
            appApiLogger.setRequestBody(requestBody);
            appApiLogger.setUrl(request.getServletPath());
            appApiLogger.setCreateTime(new Date());
            InterfaceDispatcher.builder().collect(ApiLogCallback.class).forEach(e -> e.doAfter(jp, appApiLogger));
            if (apiLog != null) {
                if (StringUtils.isBlank((CharSequence)appApiLogger.getVisitor())) {
                    appApiLogger.setVisitor(this.auth.getUser());
                }
                appApiLogger.setId(GuidGenerator.generate());
                appApiLogger.setName(apiLog.value());
                appApiLogger.setIp(request.getRemoteAddr());
                appApiLogger.setUa(request.getHeader("User-Agent"));
                if (StringUtils.isNotBlank((CharSequence)this.auth.getUser())) {
                    this.postEvent(appApiLogger);
                }
            } else {
                String apiLogClosed = this.env.getProperty("apiLog.closed");
                if (!StringUtils.isNotBlank((CharSequence)apiLogClosed) || !"true".equals(apiLogClosed.trim())) {
                    if (StringUtils.isNotBlank((CharSequence)appApiLogger.getRequestBody()) && appApiLogger.getRequestBody().length() > 512) {
                        log.info("Request.api --> [URL]: {} ; [Status]: {} ; [Times]: {} ; [AppId]: {}", new Object[]{appApiLogger.getUrl(), appApiLogger.getStatus(), appApiLogger.getTimes() + " ms" + (appApiLogger.getTimes() >= 1000L ? ", slow execution" : ""), appApiLogger.getAppId()});
                    } else {
                        log.info("Request.api --> [URL]: {} ; [Status]: {} ; [Times]: {} ; [Body]: {} ; [AppId]: {}", new Object[]{appApiLogger.getUrl(), appApiLogger.getStatus(), appApiLogger.getTimes() + " ms" + (appApiLogger.getTimes() >= 1000L ? ", slow execution" : ""), appApiLogger.getRequestBody(), appApiLogger.getAppId()});
                    }
                }
            }
            THREAD_LOCAL.remove();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void postEvent(AppApiLogger appApiLogger) {
        AsyncEventBus eventBus = new AsyncEventBus("even_api_logger", EXECUTOR);
        eventBus.register((Object)this.appApiLoggerListener);
        eventBus.post((Object)appApiLogger);
    }

    private String getBodyString(HttpServletRequest request) {
        String contentType = request.getHeader("Content-Type");
        String requestBody = "";
        if (StringUtils.isNotBlank((CharSequence)contentType) && contentType.indexOf(CONTENT_TYPE) > -1) {
            try {
                requestBody = RequestUtil.readRequestAsStream((HttpServletRequest)request);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            Enumeration parameterNames;
            HashMap<String, String> paramMap = new HashMap<String, String>();
            Enumeration e = parameterNames = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = ((String)e.nextElement()).toString();
                String value = request.getParameter(name);
                paramMap.put(name, value);
            }
            requestBody = SimpleJackson.toJson(paramMap);
        }
        return requestBody;
    }
}

