/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.interceptor;

import com.wego168.base.domain.Visit;
import com.wego168.base.domain.Visitable;
import com.wego168.base.domain.VisitableBean;
import com.wego168.base.scheduler.VisitQuantityScheduler;
import com.wego168.base.service.VisitService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class VisitQuantityInterceptor
implements HandlerInterceptor {
    public static final String targetBean = "VISITABLE_TARGET";
    @Autowired
    private VisitQuantityScheduler visitQuantityScheduler;
    @Autowired
    private VisitService visitService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        Object vistableBeanObject = request.getAttribute(targetBean);
        if (vistableBeanObject != null) {
            VisitableBean visitableBean = (VisitableBean)vistableBeanObject;
            Visitable visitable = visitableBean.getVisitable();
            String title = visitable.getTitle();
            String sourceId = visitable.getId();
            int sourceType = visitableBean.getSourceType();
            String appId = visitable.getAppId();
            String memberId = visitableBean.getMemberId();
            Visit visit = this.visitService.create(memberId, sourceId, sourceType, title, appId, request);
            this.visitQuantityScheduler.addVisitQuantity(visit, visitableBean);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

