/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.mobile;

import com.wego168.base.domain.App;
import com.wego168.base.domain.Config;
import com.wego168.base.service.AppService;
import com.wego168.base.service.ConfigService;
import com.wego168.redis.SimpleRedisTemplate;
import com.wego168.service.CrudService;
import com.wego168.util.Shift;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="mobileAppController")
@RequestMapping(value={"/api/v1/app"})
public class AppController
extends CrudController<App> {
    @Autowired
    private AppService appService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private SimpleRedisTemplate simpleRedisTemplate;

    public CrudService<App> getService() {
        return this.appService;
    }

    @GetMapping(value={"/getByCode"})
    public RestResponse get(String code) {
        String appId;
        Shift.throwsIfBlank((String)code, (String)"code\u4e0d\u80fd\u4e3a\u7a7a");
        App app = this.appService.selectByCode(code);
        if (app == null && StringUtils.isNotBlank((CharSequence)(appId = this.authenticationUser.getAppId())) && !StringUtil.equals((String)appId, (String)"0")) {
            app = (App)((Object)this.simpleRedisTemplate.get(appId, App.class));
        }
        if (app != null) {
            Config copyright;
            appId = app.getAppId();
            Config logo = this.configService.getCache("login_logo", appId);
            if (logo != null) {
                app.setLoginLogo(logo.getValue());
            }
            if ((copyright = this.configService.getCache("login_copyright", appId)) != null) {
                app.setLoginCopyright(copyright.getValue());
            }
        }
        return RestResponse.success((Object)((Object)app));
    }
}

