/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.mobile;

import com.simple.mybatis.Page;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import com.wego168.base.domain.Attachment;
import com.wego168.base.domain.Category;
import com.wego168.base.enums.CategoryCodeEnum;
import com.wego168.base.service.AttachmentService;
import com.wego168.base.service.CategoryService;
import com.wego168.util.Checker;
import com.wego168.validation.constraints.NotBlankAndLength;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
public class AttachmentController
extends SimpleController {
    private final Logger logger = LoggerFactory.getLogger(AttachmentController.class);
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private CategoryService categoryService;

    @GetMapping(value={"/api/v1/attachment/page"})
    public RestResponse listAttachment(Integer size, HttpServletRequest request) {
        if (size == null || size <= 0 || size > 6) {
            size = 6;
        }
        Page page = new Page();
        page.setCount(false);
        page.setPageNum(1);
        page.setPageSize(size.intValue());
        String appId = this.getAppId();
        page.eq("appId", (Object)appId);
        Category category = (Category)this.categoryService.selectByCode(CategoryCodeEnum.INDEX_ROLLING_PICTURE.value(), appId);
        if (category == null) {
            return RestResponse.error((String)"\u83b7\u53d6\u5931\u8d25\uff1a\u7ba1\u7406\u5458\u672a\u6b63\u786e\u914d\u7f6e\u8f6e\u64ad\u56fe\u5206\u7c7b");
        }
        page.eq("categoryId", (Object)category.getId());
        page.orderBy("seqNum asc");
        List list = this.attachmentService.selectPage(page);
        page.setList(list);
        page.setTotal(list.size());
        return RestResponse.success((Object)page);
    }

    @GetMapping(value={"/api/v1/attachment/get"})
    public RestResponse getAttachment(String id) {
        Checker.checkBlank((String)id, (String)"id");
        Attachment attachment = (Attachment)((Object)this.attachmentService.selectById(id));
        return RestResponse.success((Object)((Object)attachment));
    }

    @GetMapping(value={"/api/v1/to-base64"})
    public RestResponse imgToBase64(@NotBlankAndLength(min=5, max=512, message="\u56fe\u7247\u94fe\u63a5\u975e\u6cd5") String imageHttpUrl) {
        String base64 = this.getBase64(imageHttpUrl);
        return RestResponse.success((String)base64);
    }

    private String getBase64(String imageHttpUrl) {
        String base64 = "";
        BufferedImage image = null;
        try {
            image = ImageIO.read(new URL(imageHttpUrl));
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", stream);
            base64 = Base64.encode(stream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return base64;
    }
}

