/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.mobile;

import com.simple.mybatis.JpaCriteria;
import com.simple.mybatis.Page;
import com.wego168.base.domain.Category;
import com.wego168.base.service.CategoryService;
import com.wego168.service.CrudService;
import com.wego168.util.SimpleTree;
import com.wego168.web.controller.CrudController;
import com.wego168.web.response.RestResponse;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/category"})
public class CategoryController
extends CrudController<Category> {
    @Autowired
    private CategoryService categoryService;

    public CrudService<Category> getService() {
        return this.categoryService;
    }

    @GetMapping(value={"/listByParentId"})
    public RestResponse listByParentId(String parentId) {
        List<Category> list = this.categoryService.selectListByParentId(parentId);
        return RestResponse.success(list);
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/listByTypeAndParentId"})
    public RestResponse listByTypeAndParentId(Integer type, String storeId, String parentId) {
        if (StringUtils.isBlank((CharSequence)parentId)) {
            parentId = "0";
        }
        List<Category> list = this.categoryService.listByTypeAndParent(type, storeId, parentId);
        return RestResponse.success(list);
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u6811\u7ed3\u6784")
    @GetMapping(value={"/treeByType"})
    public RestResponse treeByType(Integer type) {
        List<Category> list = this.categoryService.listByType(type);
        SimpleTree simpleTree = new SimpleTree();
        List treeList = simpleTree.initTree(list);
        return RestResponse.success((Object)treeList);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7c7b\u522b")
    @GetMapping(value={"/page"})
    public RestResponse page(HttpServletRequest request) {
        return super.page(request);
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/listByType"})
    public RestResponse listByType(Integer type) {
        List<Category> list = this.categoryService.listByType(type);
        return RestResponse.success(list);
    }

    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u548cAppId\u83b7\u53d6\u5217\u8868")
    @GetMapping(value={"/listByTypeAndAppId"})
    public RestResponse listByTypeAndAppId(HttpServletRequest request) {
        Page page = this.buildPage(request);
        page.eq("type").eq("appId").orderBy("seqNum asc");
        List list = this.categoryService.selectList((JpaCriteria)page);
        return RestResponse.success((Object)list);
    }

    @GetMapping(value={"/get"})
    public RestResponse get(String id) {
        return super.get(id);
    }
}

