/*
 * Decompiled with CFR 0.152.
 */
package com.wego168.base.mobile;

import com.simple.mybatis.Page;
import com.wego168.base.domain.Comment;
import com.wego168.base.domain.Commentable;
import com.wego168.base.enums.CommentAuditStatusEnum;
import com.wego168.base.service.CommentService;
import com.wego168.base.service.SourceDataService;
import com.wego168.base.service.callback.Callback;
import com.wego168.domain.GenericDomain;
import com.wego168.util.Checker;
import com.wego168.util.StringUtil;
import com.wego168.web.controller.SimpleController;
import com.wego168.web.response.RestResponse;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class CommentControllerSupport
extends SimpleController {
    public RestResponse publishComment(String memberId, String content, String sourceId, Integer sourceType, Integer auditStatus, String parentId, Date createTime, HttpServletRequest request, HttpServletResponse response) {
        Comment parentComment;
        Checker.checkBlankAndLength((String)content, (String)"\u8bc4\u8bba\u5185\u5bb9", (int)256);
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        this.checkSpaceLock(memberId, sourceId);
        GenericDomain source = this.sourceIsValid(sourceId, sourceType);
        if (source == null) {
            return RestResponse.error((String)"\u9519\u8bef\u7684\u6765\u6e90");
        }
        if (StringUtil.isNotBlank((String)parentId) && (parentComment = this.getCommentService().selectById(parentId)) == null) {
            return RestResponse.error((String)"\u8be5\u8bc4\u8bba\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        String appId = source.getAppId();
        auditStatus = auditStatus == null ? CommentAuditStatusEnum.UNAUDIT.value() : auditStatus.intValue();
        Comment comment = this.getCommentService().create(content, memberId, sourceId, parentId, sourceType, auditStatus, appId);
        if (createTime != null) {
            comment.setCreateTime(createTime);
        }
        if (source instanceof Commentable) {
            Commentable commentable = (Commentable)source;
            this.getCommentService().addComment(comment, commentable, new Callback<Commentable>(){

                @Override
                public Commentable execute(Commentable commentable) {
                    commentable.setCommentQuantity(commentable.getCommentQuantity() + 1);
                    CommentControllerSupport.this.getCommentService().updateCommentQuantity(commentable);
                    return commentable;
                }
            });
        } else {
            this.getCommentService().insert((Object)comment);
        }
        this.addSpaceLock(memberId, sourceId);
        return RestResponse.success((Object)((Object)comment));
    }

    public RestResponse publishCommentOpenId(String openId, String content, String sourceId, Integer sourceType, Integer auditStatus, String parentId, Date createTime, HttpServletRequest request, HttpServletResponse response) {
        Comment parentComment;
        Checker.checkBlankAndLength((String)content, (String)"\u8bc4\u8bba\u5185\u5bb9", (int)256);
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        this.checkSpaceLock(openId, sourceId);
        GenericDomain source = this.sourceIsValid(sourceId, sourceType);
        if (source == null) {
            return RestResponse.error((String)"\u9519\u8bef\u7684\u6765\u6e90");
        }
        if (StringUtil.isNotBlank((String)parentId) && (parentComment = this.getCommentService().selectById(parentId)) == null) {
            return RestResponse.error((String)"\u8be5\u8bc4\u8bba\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        String appId = source.getAppId();
        auditStatus = auditStatus == null ? CommentAuditStatusEnum.UNAUDIT.value() : auditStatus.intValue();
        Comment comment = this.getCommentService().createByOpenId(content, openId, sourceId, parentId, sourceType, auditStatus, appId);
        if (createTime != null) {
            comment.setCreateTime(createTime);
        }
        if (source instanceof Commentable) {
            Commentable commentable = (Commentable)source;
            this.getCommentService().addComment(comment, commentable, new Callback<Commentable>(){

                @Override
                public Commentable execute(Commentable commentable) {
                    commentable.setCommentQuantity(commentable.getCommentQuantity() + 1);
                    CommentControllerSupport.this.getCommentService().updateCommentQuantity(commentable);
                    return commentable;
                }
            });
        } else {
            this.getCommentService().insert((Object)comment);
        }
        this.addSpaceLock(openId, sourceId);
        return RestResponse.success((Object)((Object)comment));
    }

    public RestResponse selectComment(String sourceId, Integer auditStatus, HttpServletRequest request) {
        Checker.checkBlank((String)sourceId, (String)"\u6765\u6e90id");
        CommentService commentService = this.getCommentService();
        Page page = this.buildPage(request);
        List<Comment> list = commentService.selectPage(sourceId, auditStatus, page);
        page.setList(list);
        return RestResponse.success((Object)page);
    }

    public RestResponse deleteComment(String id, String sourceId, String memberId, Integer sourceType, HttpServletRequest request, HttpServletResponse response) {
        Comment comment = this.getCommentService().selectById(id, memberId);
        if (comment == null) {
            return RestResponse.error((String)"\u8be5\u8bc4\u8bba\u4e0d\u5b58\u5728");
        }
        GenericDomain source = this.sourceIsValid(sourceId, sourceType);
        if (source == null) {
            return RestResponse.error((String)"\u9519\u8bef\u7684\u6765\u6e90");
        }
        if (source instanceof Commentable) {
            this.getCommentService().deleteComment(id, (Commentable)source, new Callback<Commentable>(){

                @Override
                public Commentable execute(Commentable commentable) {
                    commentable.setCommentQuantity(commentable.getCommentQuantity() - 1);
                    CommentControllerSupport.this.getCommentService().updateCommentQuantity(commentable);
                    return commentable;
                }
            });
        } else {
            this.getCommentService().deleteById(id);
        }
        return RestResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    protected abstract GenericDomain sourceIsValid(String var1, int var2);

    protected abstract CommentService getCommentService();

    protected abstract SourceDataService getSourceDataService();

    protected abstract String getLoginMemberId(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract void checkSpaceLock(String var1, String var2);

    protected abstract void addSpaceLock(String var1, String var2);
}

